package Application::Model::Page::OutDoor;

use qbit;
use base qw( Application::Model::Page::Dooh );

use PiConstants qw(:ROLES $OUTDOOR_DUMMY_DOMAIN $OUTDOOR_FACILITY_TYPE);

sub facility_type {$OUTDOOR_FACILITY_TYPE}

sub accessor      {'outdoor'}
sub db_table_name {'outdoor'}

sub get_product_name {gettext('outdoor')}

sub get_block_model_names {
    ['outdoor_block'];
}

sub get_opts_schema_name {'outdoor_opts'}

sub get_dooh_dummy_domain {$OUTDOOR_DUMMY_DOMAIN}

sub get_own_role {$OUTDOOR_PARTNER_ROLE_ID}

sub block_seq_db_table {$_[0]->partner_db->outdoor_block_seq}

sub get_structure_model_accessors {
    return {
        partner_db    => 'Application::Model::PartnerDB',
        outdoor_block => 'Application::Model::Block::OutDoor',
        users         => 'Application::Model::Users',
    };
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields()},
        # overwrite
        product_type     => {db => TRUE, db_expr => \'outdoor'},
        available_blocks => {
            depends_on => [qw(multistate owner_id)],
            get        => sub {
                return $_[0]->model->get_available_block_model_names($_[1]);
            },
            type     => 'array',
            sub_type => 'string',
            api      => 1,
        },
    };
}

sub get_fields_moderated {
    my ($self) = @_;

    return {caption => TRUE};
}

TRUE;
