package Application::Model::PageOptions;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Validation::BadArguments;

sub accessor      {'page_options'}
sub db_table_name {'page_options'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB',);

__PACKAGE__->model_fields(
    page_id      => {default => TRUE, db => TRUE, pk => TRUE,},
    json_options => {db      => TRUE,},
    options      => {
        default    => TRUE,
        depends_on => ['json_options'],
        get        => sub {
            return from_json($_[1]->{'json_options'} // '{}');
          }
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        page_id      => {type => 'number', label => d_gettext('Page ID')},
        json_options => {type => 'text',   label => d_gettext('Options')},
    },
);

sub get_options {
    my ($self, $page_id, %opts) = @_;

    my $enable  = delete($opts{'enable'})  // [];
    my $disable = delete($opts{'disable'}) // [];

    my $db_data = $self->get($page_id, fields => ['options']);

    my %enable = map {$_ => TRUE} @$enable, (defined($db_data) ? @{$db_data->{'options'}{'enable'}} : ());

    my @bad_options = ();
    my %disable     = ();
    foreach (@$disable, (defined($db_data) ? @{$db_data->{'options'}{'disable'}} : ())) {
        push(@bad_options, $_) if $enable{$_};
        $disable{$_} = TRUE;
    }

    throw Exception::Validation::BadArguments gettext('The following options are configured incorrectly: %s',
        join(', ', @bad_options))
      if @bad_options;

    return {Enable => [sort keys(%enable)], Disable => [sort keys(%disable)]};
}

sub update {
    my ($self, $page_id, %opts) = @_;

    $self->app->validator->check(
        data     => \%opts,
        template => {
            type   => 'hash',
            fields => {
                enable  => {type => 'array'},
                disable => {type => 'array'},
            },
        },
        throw => TRUE,
    );

    my %enable = map {$_ => TRUE} @{$opts{'enable'}};

    my @bad_options = ();
    my %disable     = ();
    foreach (@{$opts{'disable'}}) {
        push(@bad_options, $_) if $enable{$_};
        $disable{$_} = TRUE;
    }

    throw Exception::Validation::BadArguments gettext('The following options are configured incorrectly: %s',
        join(', ', @bad_options))
      if @bad_options;

    $self->partner_db_table()->replace(
        {
            page_id      => $page_id,
            json_options => to_json({enable => [sort keys(%enable)], disable => [sort keys(%disable)]}, canonical => 1)
        }
    );
}

TRUE;
