package Application::Model::PagesBS;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'pagesbs'}
sub db_table_name {'pagesbs'}

__PACKAGE__->model_accessors(
    api_http_bk => 'QBit::Application::Model::API::Yandex::HTTPBK',
    partner_db  => 'Application::Model::PartnerDB::InternalContextOnSite',
);

# NOTE! Пустой model_filter нужен для того чтобы работал $self->partner_db_table()
__PACKAGE__->model_filter(db_accessor => 'partner_db',);

__PACKAGE__->model_fields(page_id => {db => TRUE},);

sub get_partner_pages {
    my ($self) = @_;

    my $partner_pages = $self->api_http_bk->get_partner_pages();

    $self->partner_db->transaction(
        sub {
            $self->partner_db_table()->delete($self->partner_db->filter([page_id => '>=' => \0]));
            my $add_rows = $self->partner_db_table()->add_multi($partner_pages);
        }
    );
}

TRUE;
