package Application::Model::PartnerDB;

use qbit;
use Utils::Logger qw(ERROR INFO);
use Time::HiRes qw(gettimeofday tv_interval);

use base qw(
  Application::Model::PartnerDB::AllBlocks
  Application::Model::PartnerDB::AllPages
  Application::Model::PartnerDB::AllSources
  Application::Model::PartnerDB::Articles
  Application::Model::PartnerDB::Assistants
  Application::Model::PartnerDB::BadDomainsExclude
  Application::Model::PartnerDB::BKLanguage
  Application::Model::PartnerDB::BlockPresets
  Application::Model::PartnerDB::Brands
  Application::Model::PartnerDB::BusinessRules
  Application::Model::PartnerDB::ContextOnSite
  Application::Model::PartnerDB::Contracts
  Application::Model::PartnerDB::CookieMatch
  Application::Model::PartnerDB::Crons
  Application::Model::PartnerDB::CustomBKOptions
  Application::Model::PartnerDB::DesignTemplates
  Application::Model::PartnerDB::Distribution
  Application::Model::PartnerDB::DSP
  Application::Model::PartnerDB::EventLog
  Application::Model::PartnerDB::Excluded
  Application::Model::PartnerDB::FastBan
  Application::Model::PartnerDB::Fias
  Application::Model::PartnerDB::Filters
  Application::Model::PartnerDB::GeoBase
  Application::Model::PartnerDB::HeavyPages
  Application::Model::PartnerDB::HourGlass
  Application::Model::PartnerDB::InDoor
  Application::Model::PartnerDB::IntAPI
  Application::Model::PartnerDB::InternalContextOnSite
  Application::Model::PartnerDB::InternalMobileApp
  Application::Model::PartnerDB::InternalSearchOnSite
  Application::Model::PartnerDB::InternalSite
  Application::Model::PartnerDB::Inviter
  Application::Model::PartnerDB::KvStoreFrontend
  Application::Model::PartnerDB::MailNotification
  Application::Model::PartnerDB::Managers
  Application::Model::PartnerDB::MDS
  Application::Model::PartnerDB::MediaSizes
  Application::Model::PartnerDB::MetrikaCounters
  Application::Model::PartnerDB::Migrations
  Application::Model::PartnerDB::MobileApp
  Application::Model::PartnerDB::Moderation
  Application::Model::PartnerDB::News
  Application::Model::PartnerDB::Notification
  Application::Model::PartnerDB::OutDoor
  Application::Model::PartnerDB::PageIdGenerator
  Application::Model::PartnerDB::PageOptions
  Application::Model::PartnerDB::Pages
  Application::Model::PartnerDB::PagesBS
  Application::Model::PartnerDB::PICategories
  Application::Model::PartnerDB::QualityCoef
  Application::Model::PartnerDB::Queue
  Application::Model::PartnerDB::SearchOnSite
  Application::Model::PartnerDB::Sender
  Application::Model::PartnerDB::ShortLink
  Application::Model::PartnerDB::SimpleNotification
  Application::Model::PartnerDB::Site
  Application::Model::PartnerDB::SSP
  Application::Model::PartnerDB::StatDownloadData
  Application::Model::PartnerDB::Statistics
  Application::Model::PartnerDB::StatisticsReports
  Application::Model::PartnerDB::SystemEvents
  Application::Model::PartnerDB::TextTemplate
  Application::Model::PartnerDB::ThematicFilters
  Application::Model::PartnerDB::TNSDicts
  Application::Model::PartnerDB::UpdateStatus
  Application::Model::PartnerDB::Users
  Application::Model::PartnerDB::VideoAN
  Application::Model::PartnerDB::Widgets
  Application::Model::PartnerDB::YaCategories
  QBit::Application::Model::DB::mysql::KvStore
  QBit::Application::Model::DB::mysql::RBAC
  );

sub accessor {'partner_db'}

my $TIMEOUT_MESSAGE = 'ERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction';

sub update_table {
    my ($self, $table_name, $code, $timeout) = @_;

    my $t0 = [gettimeofday()];

    my $new_table_name = $table_name . '_new';

    $self->make_tables({$new_table_name => $table_name});

    my $new_table = $self->$new_table_name;

    $new_table->drop(if_exists => TRUE);
    $new_table->create();
    $new_table->alter(disable_keys => TRUE);

    $code->($new_table);

    $new_table->alter(enable_keys => TRUE);

    if ($timeout && $timeout->{timeout} && $timeout->{tries}) {
        my $var_lock_wait_timeout = $self->get_dbh()->selectrow_hashref("show variables like 'lock_wait_timeout%';");
        $self->_do(sprintf('SET SESSION lock_wait_timeout = %d;', $timeout->{timeout}));
        my ($done, $tries) = (FALSE, $timeout->{tries});
        my $t1 = [gettimeofday()];
        while (!$done && (0 < $tries--)) {
            try {
                $new_table->swap($table_name);
                $done = TRUE;
            }
            catch {
                my ($e) = @_;
                my $elapsed1 = tv_interval($t1, [gettimeofday()]);
                unless ($e->message =~ /^$TIMEOUT_MESSAGE/) {
                    ERROR {
                        message => $e->message,
                        extra   => {
                            elapsed => $elapsed1,
                            tries   => $timeout->{tries} - $tries,
                        },
                        fingerprint => ['PartnerDB', 'update_table']
                    };
                } else {
                    INFO(sprintf('%s, elapsed: %s, tries: %s', $@->message, $elapsed1, $timeout->{tries} - $tries));
                }
            };
        }
        unless ($done) {
            ERROR {
                message     => 'Failed to rename table (update_table.swap) in time',
                fingerprint => ['PartnerDB', 'update_table']
            };
        }
        $self->_do(sprintf('SET SESSION lock_wait_timeout = %d;', $var_lock_wait_timeout->{Value} // 31536000));
    } else {
        $new_table->swap($table_name);
    }

    $new_table->drop();
    INFO(sprintf('update_table done, elapsed: %s', tv_interval($t0, [gettimeofday()])));
}

TRUE;
