package Application::Model::PartnerDB::AllBlocks;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

my $FILEDS = [
    {name => 'page_id',           type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
    {name => 'id',                type => 'INT',     unsigned => TRUE, not_null => TRUE},
    {name => 'model',             type => 'VARCHAR', length   => 64,   not_null => TRUE},
    {name => 'caption',           type => 'VARCHAR', length   => 255,  not_null => TRUE},
    {name => 'multistate',        type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
    {name => 'site_version',      type => 'VARCHAR', length   => 64},
    {name => 'adfox_block',       type => 'BOOLEAN', unsigned => TRUE},
    {name => 'mobile_block_type', type => 'VARCHAR', length   => 64},
    {name => 'video_block_type',  type => 'TINYINT', unsigned => TRUE},
    {name => 'disposition_id',    type => 'TINYINT', unsigned => TRUE},
    {name => 'place_id',          type => 'INT',     unsigned => TRUE},
    {name => 'category_id',       type => 'BIGINT',  unsigned => TRUE},
];

__PACKAGE__->meta(
    tables => {
        all_blocks => {
            fields => [
                {
                    name          => 'id_autoincrement',
                    type          => 'BIGINT',
                    unsigned      => TRUE,
                    not_null      => TRUE,
                    autoincrement => TRUE
                },
                @$FILEDS
            ],
            primary_key => ['id_autoincrement'],
            indexes     => [{fields => [qw(model page_id id)], unique => 1}, {fields => [qw(adfox_block)]},],
        },

        all_blocks_view => {
            is_view => TRUE,
            fields  => $FILEDS,
            view_of => sub {
                my ($app) = @_;

                my %old_blocks = map {$_ => TRUE} @{$app->product_manager->get_old_block_model_accessors()};

                return [grep {!$old_blocks{$_}} @{$app->product_manager->get_block_model_accessors()}];
            },
            view_sql => sub {
                my ($app) = @_;

                sprintf(
                    qq{CREATE OR REPLACE
VIEW `all_blocks_view` (
    %s
) AS
%s;
}, _get_fields_for_blocks($app), join("\nUNION ALL\n", _get_sqls_for_blocks($app))
                );
              }
        },
    }
);

sub _get_fields_for_blocks {
    my ($app) = @_;

    return join(",\n    ",
        map  {$app->partner_db->quote_identifier($_->{'name'})}
        sort {$a->{'name'} cmp $b->{'name'}} @$FILEDS);
}

sub _get_sqls_for_blocks {
    my ($app) = @_;

    my $fields = [
        {
            dictionary_field => 'page_id',
            possible_options =>
              [{field => 'campaign_id',}, {field => 'context_page_id',}, {field => 'application_id',},]
        },
        {dictionary_field => 'id',},
        {
            dictionary_field => 'caption',
            possible_options => [{field => 'title',},],
        },
        {dictionary_field => 'multistate',},
        {dictionary_field => 'adfox_block',},
        {dictionary_field => 'site_version',},
        {
            dictionary_field => 'mobile_block_type',
            possible_options => [{field => 'block_type',},],
        },
        {
            dictionary_field => 'video_block_type',
            possible_options => [
                {
                    field => 'type',
                    check => sub {
                        my ($app, $block_model) = @_;

                        return in_array(
                            $block_model,
                            [
                                qw(
                                  video_an_site_instream
                                  video_an_site_inpage
                                  video_an_site_fullscreen
                                  )
                            ]
                        );
                    },
                },
            ],
        },
        {dictionary_field => 'disposition_id',},
        {dictionary_field => 'place_id',},
        {dictionary_field => 'category_id',},
    ];

    my %old_blocks = map {$_ => TRUE} @{$app->product_manager->get_old_block_model_accessors()};

    my @sqls = ();
    foreach my $block_model (sort @{$app->product_manager->get_block_model_accessors()}) {
        next if $old_blocks{$block_model};

        my %table_fields = map {$_ => TRUE} $app->partner_db->$block_model->field_names();

        my $db_fields = {model => $table_fields{'model'} ? '' : \$block_model};

        foreach my $def (@$fields) {
            my ($dictionary_field, $possible_options) = @$def{qw(dictionary_field possible_options)};

            if ($table_fields{$dictionary_field}) {
                $db_fields->{$dictionary_field} = $dictionary_field;

                next;
            }

            foreach my $option (@{$possible_options // []}) {
                if (exists($option->{'check'}) && !$option->{'check'}->($app, $block_model)) {
                    next;
                }

                if ($table_fields{$option->{'field'}}) {
                    $db_fields->{$dictionary_field} = $option->{'field'};

                    last;
                }
            }
        }

        foreach (grep {!exists($db_fields->{$_})} map {$_->{'dictionary_field'}} @$fields) {
            $db_fields->{$_} = \undef;
        }

        push(
            @sqls,
            $app->partner_db->query->select(
                table  => $app->partner_db->$block_model,
                fields => $db_fields,
                ($table_fields{'active'} ? (filter => ['active', '=', \1]) : ())
              )->get_sql_with_data()
            );
    }

    return @sqls;
}

TRUE;
