package Application::Model::PartnerDB::AllPages;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw( $ADINSIDE_USER_ID $ADINSIDE_CLIENT_ID $INDOOR_DUMMY_DOMAIN $OUTDOOR_DUMMY_DOMAIN );

our $TABLES = [
    {
        table      => 'context_on_site_campaign',
        fields     => {product_type => \'context',},
        multistate => {
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            balance_registered => 16,
            read_only          => 32,
            blocked            => 128,
            rejected           => 512,
            protected          => 1024,
        },
        join => q[
            JOIN site             ON site.id  = page.domain_id
            JOIN users            ON users.id = page.owner_id
            LEFT JOIN all_sources ON all_sources.local_id = page.domain_id AND all_sources.model = 'site']
    },
    {
        table      => 'search_on_site_campaign',
        fields     => {product_type => \'search',},
        multistate => {
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            balance_registered => 16,
            read_only          => 32,
            blocked            => 128,
            rejected           => 512,
            protected          => 1024,
        },
        join => q[
            JOIN site             ON site.id  = page.domain_id
            JOIN users            ON users.id = page.owner_id
            LEFT JOIN all_sources ON all_sources.local_id = page.domain_id AND all_sources.model = 'site']
    },
    {
        table  => 'mobile_app_settings',
        fields => {
            product_type => \'mobile',

            page_id   => 'page.context_page_id',
            domain_id => 'page.application_id',
            domain    => 'app.store_id',
        },
        multistate => {
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            balance_registered => 32,
            blocked            => 128,
            protected          => 256,
            rejected           => 4096,
        },
        join => q[
            JOIN mobile_app app   ON app.id   = page.application_id
            JOIN users            ON users.id = page.`owner_id`
            LEFT JOIN all_sources ON all_sources.local_id = page.application_id AND all_sources.model = 'mobile_app']
    },
    {
        table  => 'video_an_site',
        fields => {
            product_type => \'video',
            page_id      => 'page.id',
            domain_id    => 'page.id',
            domain       => 'page.domain',
        },
        multistate => {
            balance_registered => undef,
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            protected          => 32,
            rejected           => 512,
            blocked            => 1024,
        },
        join => q[
            JOIN `users`          ON users.`id` = page.`owner_id`
            LEFT JOIN all_sources ON all_sources.local_id = page.id AND all_sources.model = 'video_an_site']
    },
    {
        table  => 'indoor',
        fields => {
            product_type => \'video',
            is_internal  => \0,
            caption      => 'JSON_UNQUOTE(page.caption)',
            domain_id    => 'page.id',
            domain       => \$INDOOR_DUMMY_DOMAIN,
        },
        multistate => {
            working            => 1,
            stopped            => 2,
            deleted            => 4,
            read_only          => 32,
            protected          => 64,
            balance_registered => 256,
            need_approve       => 512,
            approved           => 1024,
            rejected           => 2048,
            blocked            => 4096,
        },
        join => q[
            JOIN users            ON users.id = page.owner_id
            LEFT JOIN all_sources ON all_sources.local_id = page.id AND all_sources.model = 'indoor']
    },
    {
        table  => 'outdoor',
        fields => {
            product_type => \'video',
            is_internal  => \0,
            caption      => 'JSON_UNQUOTE(page.caption)',
            domain_id    => 'page.id',
            domain       => \$OUTDOOR_DUMMY_DOMAIN,
        },
        multistate => {
            working            => 1,
            stopped            => 2,
            deleted            => 4,
            read_only          => 32,
            protected          => 64,
            balance_registered => 256,
            need_approve       => 512,
            approved           => 1024,
            rejected           => 2048,
            blocked            => 4096,
        },
        join => q[
            JOIN users            ON users.id = page.owner_id
            LEFT JOIN all_sources ON all_sources.local_id = page.id AND all_sources.model = 'outdoor']
    },
    {
        table  => 'internal_context_on_site_campaign',
        fields => {
            product_type  => \'context',
            is_internal   => \1,
            page_id       => 'page.id',
            caption       => 'site.domain',
            domain_id     => 'page.site_id',
            owner_id      => \$ADINSIDE_USER_ID,
            login         => \'adinside',
            client_id     => \$ADINSIDE_CLIENT_ID,
            business_unit => \0,
        },
        multistate => {
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            balance_registered => 16,
            read_only          => 32,
            protected          => 128,
        },
        join => q[
            JOIN internal_site site ON site.id = page.site_id
            LEFT JOIN all_sources   ON all_sources.local_id = page.site_id AND all_sources.model = 'internal_site']
    },
    {
        table  => 'internal_search_on_site_campaign',
        fields => {
            product_type  => \'search',
            is_internal   => \1,
            page_id       => 'page.id',
            caption       => 'site.domain',
            domain_id     => 'page.site_id',
            owner_id      => \$ADINSIDE_USER_ID,
            login         => \'adinside',
            client_id     => \$ADINSIDE_CLIENT_ID,
            business_unit => \0,
        },
        multistate => {
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            balance_registered => 16,
            read_only          => 32,
            protected          => 128,
        },
        join => q[
            JOIN internal_site site ON site.id = page.site_id
            LEFT JOIN all_sources   ON all_sources.local_id = page.site_id AND all_sources.model = 'internal_site']
    },
    {
        table  => 'internal_mobile_app',
        fields => {
            product_type  => \'mobile',
            is_internal   => \1,
            page_id       => 'page.id',
            domain_id     => 'page.id',
            domain        => 'page.store_id',
            owner_id      => \$ADINSIDE_USER_ID,
            login         => \'adinside',
            client_id     => \$ADINSIDE_CLIENT_ID,
            business_unit => \0,
        },
        multistate => {
            balance_registered => undef,
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            protected          => 32,
        },
        join => q[
            LEFT JOIN all_sources ON all_sources.local_id = page.id AND all_sources.model = 'internal_mobile_app']
    },
    {
        table  => 'ssp_mobile_app_settings',
        fields => {
            product_type  => \'mobile',
            caption       => 'app.bundle_id',
            domain_id     => 'app.id',
            domain        => 'app.bundle_id',
            client_id     => 'seller.client_id',
            business_unit => \0
        },
        multistate => {
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            balance_registered => 16,
            read_only          => 32,
            blocked            => 128,
            rejected           => 512,
            protected          => 1024,
        },
        join => q[
            JOIN ssp_link_mobile_app AS link   ON link.mobile_app_id = page.id
            JOIN ssp_application     AS app    ON app.id = link.application_id
            JOIN ssp_seller          AS seller ON seller.id = link.seller_id
            JOIN users                         ON users.client_id = seller.client_id
            LEFT JOIN all_sources              ON all_sources.local_id = app.id AND all_sources.model = 'ssp_application']
    },
    {
        table  => 'ssp_context_on_site_campaign',
        fields => {
            product_type  => \'context',
            caption       => 'site.domain',
            domain_id     => 'site.id',
            client_id     => 'seller.client_id',
            business_unit => \0
        },
        multistate => {
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            balance_registered => 16,
            read_only          => 32,
            blocked            => 128,
            rejected           => 512,
            protected          => 1024,
        },
        join => q[
            JOIN ssp_link_context_rtb AS link   ON link.context_rtb_id = page.id
            JOIN ssp_site             AS site   ON site.id = link.site_id
            JOIN ssp_seller           AS seller ON seller.id = link.seller_id
            JOIN users                          ON users.client_id = seller.client_id
            LEFT JOIN all_sources               ON all_sources.local_id = site.id AND all_sources.model = 'ssp_site']
    },
    {
        table  => 'ssp_video_an_site',
        fields => {
            product_type  => \'video',
            caption       => 'app.bundle_id',
            domain_id     => 'app.id',
            domain        => 'app.bundle_id',
            business_unit => \0
        },
        multistate => {
            working            => 1,
            stopped            => 4,
            deleted            => 8,
            balance_registered => 16,
            read_only          => 32,
            blocked            => 128,
            rejected           => 512,
            protected          => 1024,
        },
        join => q[
            JOIN ssp_link_video_app  AS link   ON link.video_app_id = page.id
            JOIN ssp_application     AS app    ON app.id = link.application_id
            JOIN ssp_seller          AS seller ON seller.id = link.seller_id
            JOIN users                         ON users.client_id = seller.client_id
            LEFT JOIN all_sources              ON all_sources.local_id = app.id AND all_sources.model = 'ssp_application']
    },
    {
        table  => 'distribution_campaign',
        fields => {
            product_type => \'distribution',
            is_internal  => \0,
            domain_id    => \0,
            domain       => \'',
        },
        multistate => {
            working   => 1,
            stopped   => 4,
            deleted   => 8,
            read_only => 32,
            blocked   => 128,
            rejected  => 512,
            protected => 1024,
        },
        join => q[
            JOIN `users`          ON users.`id` = page.`owner_id`
            LEFT JOIN all_sources ON all_sources.local_id = page.id AND all_sources.model = 'distribution_campaign']
    },
];

our @all_pages_table_queries = ();
foreach my $t_data (@$TABLES) {

    my ($table_name, $join_tables) = @$t_data{qw( table  join )};
    $join_tables //= '';

    my (
        $model,     $is_internal, $product_type, $id,       $page_id, $caption,   $domain_id,
        $source_id, $domain,      $multistate,   $owner_id, $login,   $client_id, $business_unit
       )
      = @{$t_data->{fields}}{
        qw(
          model  is_internal  product_type  id  page_id  caption  domain_id
          source_id domain multistate owner_id  login  client_id  business_unit
          )
      };

    $model         //= \$table_name;
    $is_internal   //= \0;
    $id            //= 'page.id';
    $page_id       //= 'page.page_id';
    $caption       //= 'page.caption';
    $domain_id     //= 'page.domain_id';
    $source_id     //= 'all_sources.id';
    $domain        //= 'site.domain';
    $multistate    //= 'page.multistate';
    $owner_id      //= 'users.id';
    $login         //= 'users.login';
    $client_id     //= 'users.client_id';
    $business_unit //= 'users.business_unit';

    my ($is_working, $is_stopped, $is_deleted, $is_readonly, $is_blocked, $is_rejected, $is_protected) =
      map {$_ ? sprintf('if(page.multistate & %d, 1, 0)', $_) : 0} @{$t_data->{multistate}}{
        qw(
          working
          stopped
          deleted
          read_only
          blocked
          rejected
          protected
          )
      };
    my $is_balance_registered = (
        $t_data->{multistate}{balance_registered}
        ? sprintf('if(page.multistate & %d, 1, 0)', $t_data->{multistate}{balance_registered})
        : 1
    );

    (
        $model,        $is_internal, $product_type, $id,            $page_id,
        $caption,      $domain_id,   $source_id,    $domain,        $multistate,
        $owner_id,     $login,       $client_id,    $business_unit, $is_working,
        $is_stopped,   $is_deleted,  $is_readonly,  $is_blocked,    $is_rejected,
        $is_protected, $is_balance_registered
    )
      = map {sprintf '%-32s', ref($_) ? sprintf(q['%s'], $$_) : $_} $model, $is_internal, $product_type, $id, $page_id,
      $caption,    $domain_id,
      $source_id,  $domain, $multistate, $owner_id, $login, $client_id, $business_unit,
      $is_working, $is_stopped, $is_deleted, $is_readonly, $is_blocked, $is_rejected, $is_protected,
      $is_balance_registered;

    push @all_pages_table_queries, qq[SELECT
            ${id} AS `id`,
            ${model} AS `model`,
            ${page_id} AS `page_id`,
            ${caption} AS `caption`,
            ${domain_id} AS `domain_id`,
            ${source_id} AS `source_id`,
            ${domain} AS `domain`,
            ${multistate} AS `multistate`,

            ${is_internal} AS `is_internal`,
            ${is_working} AS `is_working`,
            ${is_stopped} AS `is_stopped`,
            ${is_deleted} AS `is_deleted`,
            ${is_readonly} AS `is_readonly`,
            ${is_blocked} AS `is_blocked`,
            ${is_rejected} AS `is_rejected`,
            ${is_protected} AS `is_protected`,
            ${is_balance_registered} AS `is_balance_registered`,

            ${product_type} AS `product_type`,
            ${owner_id} AS `owner_id`,
            ${login} AS `login`,
            ${client_id} AS `client_id`,
            ${business_unit} AS `business_unit`,

            page.create_date,
            page.update_time,
            page.send_time

        FROM `${table_name}` page${join_tables}];
}

my $FIELDS = [
    {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
    {name => 'model',   type => 'VARCHAR', length   => 255, not_null => TRUE, default => ''},
    {name => 'page_id', type => 'INT',     unsigned => TRUE},
    {name => 'caption', type => 'VARCHAR', length   => 255, not_null => TRUE, default => ''},
    {name => 'domain_id',  type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
    {name => 'source_id',  type => 'BIGINT',  unsigned => TRUE, not_null => FALSE},
    {name => 'domain',     type => 'VARCHAR', length   => 255,  not_null => TRUE},
    {name => 'multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},

    {name => 'is_internal',           type => 'BOOLEAN', not_null => TRUE, default => 0},
    {name => 'is_working',            type => 'BOOLEAN', not_null => TRUE, default => 0},
    {name => 'is_stopped',            type => 'BOOLEAN', not_null => TRUE, default => 0},
    {name => 'is_deleted',            type => 'BOOLEAN', not_null => TRUE, default => 0},
    {name => 'is_readonly',           type => 'BOOLEAN', not_null => TRUE, default => 0},
    {name => 'is_blocked',            type => 'BOOLEAN', not_null => TRUE, default => 0},
    {name => 'is_rejected',           type => 'BOOLEAN', not_null => TRUE, default => 0},
    {name => 'is_protected',          type => 'BOOLEAN', not_null => TRUE, default => 0},
    {name => 'is_balance_registered', type => 'BOOLEAN', not_null => TRUE, default => 0},

    {name => 'product_type',  type => 'VARCHAR',  length   => 255,  not_null => TRUE, default => ''},
    {name => 'owner_id',      type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
    {name => 'login',         type => 'VARCHAR',  length   => 40,   not_null => TRUE, default => ''},
    {name => 'client_id',     type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
    {name => 'business_unit', type => 'BOOLEAN',  not_null => TRUE, default  => 0},
    {name => 'create_date',   type => 'DATETIME', not_null => TRUE},
    {name => 'update_time',   type => 'DATETIME', not_null => TRUE},
    {name => 'send_time',     type => 'DATETIME', not_null => TRUE},
];

__PACKAGE__->meta(
    tables => {
        all_pages => {
            fields      => $FIELDS,
            primary_key => ['id', 'model'],
            indexes =>
              [{fields => ['page_id']}, {fields => ['owner_id']}, {fields => ['client_id']}, {fields => ['domain_id']}]
        },

        need_update_pages => {
            fields => [
                {name => 'id',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'page_id', type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'model',   type => 'VARCHAR', length   => 255,  not_null => TRUE,},
                {name => 'update_time',  type => 'DATETIME', not_null => TRUE,},
                {name => 'start_update', type => 'DATETIME'},
                {name => 'worker',       type => 'VARCHAR',  length   => 255,},
                {name => 'processed',   type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'stop_update', type => 'DATETIME'},
            ],
            primary_key => ['id'],
            indexes     => [{fields => ['model']}, {fields => ['worker']},],
        },

        all_pages_view => {
            is_view => TRUE,
            fields  => $FIELDS,
            view_of => sub {
                return [
                    qw(
                      users
                      context_on_site_campaign
                      search_on_site_campaign
                      site
                      mobile_app_settings
                      mobile_app
                      video_an_site
                      indoor
                      outdoor
                      internal_context_on_site_campaign
                      internal_search_on_site_campaign
                      internal_site
                      internal_mobile_app
                      distribution_campaign
                      ssp_seller
                      ssp_mobile_app_settings
                      ssp_link_mobile_app
                      ssp_context_on_site_campaign
                      ssp_link_context_rtb
                      ssp_site
                      ssp_video_an_site
                      ssp_link_video_app
                      )
                ];
            },
            view_sql => sub {
                return sprintf(
                    qq{CREATE OR REPLACE
DEFINER = 'root'\@'localhost'     -- setting 'definer' to another user requires SUPER privilege
SQL SECURITY INVOKER
VIEW `all_pages_view` (
    `id`,
    `model`,
    `page_id`,
    `caption`,
    `domain_id`,
    `source_id`,
    `domain`,
    `multistate`,

    `is_internal`,
    `is_working`,
    `is_stopped`,
    `is_deleted`,
    `is_readonly`,
    `is_blocked`,
    `is_rejected`,
    `is_protected`,
    `is_balance_registered`,

    `product_type`,
    `owner_id`,
    `login`,
    `client_id`,
    `business_unit`,

    `create_date`,
    `update_time`,
    `send_time`

    ) AS
        %s;
}, join("\n    UNION ALL\n        ", @all_pages_table_queries)
                );
              }
        },

        only_rtb_product_page => {
            fields      => [{name => 'page_id', type => 'BIGINT', unsigned => TRUE},],
            primary_key => ['page_id'],
        },
    }
);

TRUE;
