package Application::Model::PartnerDB::AllSources;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        all_sources => {
            fields => [
                {name => 'id',          type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'local_id',    type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'model',       type => 'VARCHAR', length   => 64,   not_null => TRUE},
                {name => 'domain',      type => 'VARCHAR', length   => 255,  not_null => TRUE},
                {name => 'multistate',  type => 'BIGINT',  unsigned => TRUE},
                {name => 'is_graysite', type => 'BOOLEAN', unsigned => TRUE},
                {name => 'type',        type => 'TINYINT', unsigned => TRUE},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => ['local_id', 'model'], unique => 1}],
        }
    }
);

TRUE;
