package Application::Model::PartnerDB::Assistants;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        assistants => {
            fields => [
                {name => 'id',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'page_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'user_id',},
                {name => 'can_edit',   type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'dissabled',  type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'inviter_id', type => 'CHAR',    not_null => TRUE, length  => 32,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => ['inviter_id', 'page_id', 'user_id'], unique => 1}],
            foreign_keys => [[['user_id'] => users => ['id']]]
        },
    }
);

TRUE;
