package Application::Model::PartnerDB::BlockPresets;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        block_presets => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'owner_id',},
                {name => 'caption',  type => 'VARCHAR', length   => 255, not_null => TRUE},
                {name => 'settings', type => 'JSON',    not_null => TRUE},
                {name => 'multistate',  type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE},
            ],
            primary_key  => ['id'],
            foreign_keys => [[['owner_id'] => users => ['id']]]
        },

        block_presets_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'block_presets',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },
    }
);

TRUE;
