package Application::Model::PartnerDB::Brands;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        brands => {
            fields => [
                {name => 'id',  type => 'INT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'bid', type => 'INT', not_null => TRUE},
                {name => 'block_id', type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'page_id',  type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'blocked',  type => 'BOOLEAN', not_null => TRUE, default  => 1,},
                {name => 'cpm',      type => 'DECIMAL', length   => 10,   decimals => 3,}
            ],
            primary_key => ['id'],
            indexes     => [
                {fields => [qw(bid block_id page_id)], unique => TRUE},
                {fields => [qw(page_id block_id)],     unique => FALSE},
            ],
        },
    }
);

TRUE;
