package Application::Model::PartnerDB::BusinessRules;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {

        business_rules => {
            fields => [
                {name => 'rule_id', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'owner_id',},
                {name => 'caption', type => 'VARCHAR', length   => 255,  not_null => TRUE, default       => ''},
                {name => 'cpm',        type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'conditions', type => 'TEXT', not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'position',   type => 'INT',    unsigned => TRUE, not_null => TRUE},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
            ],
            primary_key  => ['rule_id'],
            foreign_keys => [[['owner_id'] => users => ['id']]],
        },

        business_rules_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'business_rules',
            elem_table_pk => ['rule_id'],
            with_opts     => TRUE
        },

        business_blocks => {
            fields => [
                {name => 'rule_id'},
                {name => 'page_id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'block_id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'block_accessor', type => 'VARCHAR', length => 255, not_null => TRUE},
                {name => 'is_deleted', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',   type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
            ],
            primary_key => ['rule_id', 'page_id', 'block_id'],
            foreign_keys => [[['rule_id'] => 'business_rules' => ['rule_id']]],
        },

    }
);

TRUE;
