package Application::Model::PartnerDB::ContextOnSite;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME $MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        context_on_site_campaign => {
            fields => [
                {name => 'id',          type => 'INT',      unsigned => TRUE, not_null => TRUE},
                {name => 'page_id',     type => 'INT',      unsigned => TRUE,},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'domain_id',},
                {name => 'owner_id',},
                {name => 'caption',              type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'family_filter',        type => 'BOOLEAN', not_null => TRUE,  default  => 0},
                {name => 'from_trigger',         type => 'BOOLEAN', not_null => TRUE,  default  => 0},
                {name => 'behavioral_targeting', type => 'BOOLEAN', not_null => TRUE,  default  => 1},
                {name => 'view_images',          type => 'BOOLEAN', not_null => TRUE,  default  => 1},
                {name => 'reload_timeout',       type => 'TINYINT', unsigned => TRUE,  not_null => TRUE, default => 30},
                {name => 'multistate',           type => 'BIGINT',  unsigned => TRUE,  not_null => TRUE, default => 0},
                {name => 'comment',              type => 'TEXT'},
                {name => 'block_title',          type => 'VARCHAR', length   => '255', default => ''},
                {name => 'pi_id',                type => 'INT',     unsigned => TRUE},
                {name => 'fast_context',         type => 'BOOLEAN', not_null => TRUE,  default => 1},
                {name => 'only_picture',         type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'mobile_app_mode',      type => 'TINYINT', not_null => TRUE,  default => 0},
                {name => 'user_synchronization', type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'tag_id',               type => 'INT',     unsigned => TRUE,},
                {name => 'adblock',              type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'market_api',           type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'update_time',   type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',     type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'page_lang',     type => 'INT',      not_null => TRUE, unsigned => TRUE, default => 1},
                {name => 'allowed_amp',   type => 'BOOLEAN',  not_null => TRUE, default  => 1},
                {name => 'allowed_turbo', type => 'BOOLEAN',  not_null => TRUE, default  => 1},
                {name => 'metrica_counters', type => 'VARCHAR', length => '1024', not_null => TRUE, default => ''},
                {name => 'unmoderated_rtb_auction', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'performance_tgo_disable', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'blocks_limit',            type => 'BIGINT',  not_null => TRUE, default => 200},
                {name => 'blocks_count',            type => 'BIGINT',  not_null => TRUE, default => 0},
                {
                    name    => 'tier',
                    type    => 'TINYINT',
                    default => 3,
                },
                {name => 'opts',       type => 'JSON',   not_null => TRUE},
                {name => 'creator_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'patch', type => 'JSON'},
            ],
            primary_key  => ['id'],
            indexes      => [{fields => [qw(page_id)], unique => TRUE,},],
            foreign_keys => [
                [['domain_id']  => site  => ['id']],
                [['owner_id']   => users => ['id']],
                [['creator_id'] => users => ['id']],
            ]
        },

        context_on_site_campaign_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_campaign',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        context_on_site_campaign_banner_lang => {
            fields      => [{name => 'campaign_id'}, {name => 'language_id'}],
            primary_key => [qw(campaign_id language_id)],
            foreign_keys =>
              [[['campaign_id'] => context_on_site_campaign => ['id']], [['language_id'] => bk_language => ['id']]],
        },

        context_on_site_mirrors => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'campaign_id'},
                {name => 'domain', type => 'VARCHAR', length => 64, not_null => 1},
                {name => 'multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'auto',       type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'create_date',        type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'waiting_moderation', type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(campaign_id domain)], unique => 1}],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['id']]]
        },

        context_on_site_ya_categories => {
            fields => [
                {name => 'campaign_id'},
                {name => 'category_id'},
                {name => 'probability', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id category_id)],
            foreign_keys => [
                [['campaign_id'] => context_on_site_campaign => ['page_id']],
                [['category_id'] => ya_categories            => ['id']],
            ]
        },

        context_on_site_block_seq => {
            fields => [{name => 'campaign_id'}, {name => 'next_block_id', type => 'INT', unsigned => 1, not_null => 1}],
            primary_key  => ['campaign_id'],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']]]
        },

        vip => {
            fields      => [{name => 'page_id'},],
            primary_key => ['page_id'],
            foreign_keys => [[['page_id'] => context_on_site_campaign => ['page_id']]]
        },

        context_on_site_rtb => {
            type                 => 'RTBWithoutDesignFields',
            page_id_name_in_rtb  => 'campaign_id',
            page_table           => 'context_on_site_campaign',
            page_id_name_in_page => 'page_id',
            fields               => [
                {name => 'horizontal_align', type => 'BOOLEAN',  default  => 1},
                {name => 'alternative_code', type => 'TEXT',     not_null => TRUE, default => ''},
                {name => 'blind',            type => 'TINYINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'strategy',         type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 1},
                {name => 'alt_width',        type => 'SMALLINT', unsigned => TRUE,},
                {name => 'alt_height',       type => 'SMALLINT', unsigned => TRUE,},
                {name => 'active',           type => 'BOOLEAN', not_null => FALSE, default => 1},
                {name => 'ex_direct',        type => 'BOOLEAN', not_null => FALSE, default => 0},
                {name => 'duplicate_direct', type => 'BOOLEAN', not_null => FALSE, default => 0},
                {name => 'show_video',       type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'from_trigger',     type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {
                    name   => 'site_version',
                    type   => 'ENUM',
                    values => [
                        'desktop',       'mobile',            'turbo',           'amp',
                        'turbo_desktop', 'mobile_fullscreen', 'mobile_rewarded', 'mobile_floorad',
                        'general'
                    ],
                    not_null => TRUE,
                    default  => 'desktop'
                },
                {
                    name   => 'model',
                    type   => 'ENUM',
                    values => [
                        'context_on_site_rtb', 'internal_context_on_site_rtb',
                        'mobile_app_rtb',      'context_on_site_content',
                        'internal_mobile_app_rtb'
                    ],
                    not_null => TRUE,
                    default  => 'context_on_site_rtb'
                },
                {name => 'adfox_block',   type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'video_active',  type => 'BOOLEAN', default  => undef},
                {name => 'video_blocked', type => 'BOOLEAN', default  => undef},
                {
                    name     => 'video_cpm',
                    type     => 'DECIMAL',
                    length   => 10,
                    decimals => 3,
                    unsigned => TRUE,
                    default  => undef
                },
                {name => 'unique_id',    type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'block_type',   type => 'VARCHAR', length   => '18'},
                {name => 'direct_block', type => 'VARCHAR', length   => '32',},
                {name => 'media_block',  type => 'VARCHAR', length   => '12',},
                {name => 'place_id',     type => 'INT',     unsigned => TRUE},
            ],
            indexes => [{fields => ['unique_id'], unique => 1}, {fields => ['model']}],
        },

        context_on_site_rtb_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_rtb',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => {type => 'MEDIUMTEXT'},
        },

        statistics_context_on_site_rtb => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id', type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',                  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'rtb_block_shows',         type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_shows_own_adv', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits',          type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits_own_adv',  type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits_unsold',   type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_all_w_nds',           type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_all_wo_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',               type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_partner_w_nds',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_partner_wo_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',           type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_bad_shows',     type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_block_bad_win_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'rtb_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_bad_win_price_w_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'rtb_bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_block_direct_clicks', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_direct_shows',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id dsp_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => context_on_site_rtb => ['campaign_id', 'id']],
            ],
        },

        adfox_old_new_block_ids => {
            fields => [
                {name => 'page_id',      type => 'INT', unsigned => 1, not_null => 1},
                {name => 'old_block_id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'new_block_id', type => 'INT', unsigned => 1, not_null => 1},
            ],
            primary_key => [qw(page_id old_block_id)],
        },

        context_on_site_adblock => {
            fields => [
                {name => 'page_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'comment',      type => 'TEXT'},
                {name => 'direct_block', type => 'VARCHAR', length => '32', not_null => TRUE},
                {name => 'limit',      type => 'INT',      unsigned => TRUE},
                {name => 'multistate', type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'strategy',   type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 1},
                {name => 'mincpm',     type => 'SMALLINT', unsigned => TRUE,},
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT',},
                {name => 'show_video',        type => 'BOOLEAN', not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(page_id id)],
            foreign_keys => [[['page_id'] => context_on_site_campaign => ['page_id']]],
            indexes => [{fields => [qw(id)]},],
        },

        context_on_site_adblock_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_adblock',
            elem_table_pk => [qw(page_id id)],
            with_opts     => TRUE
        },

        statistics_context_on_site_adblock => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id', type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'adblock_block_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'adblock_block_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'adblock_block_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'adblock_block_hits_own_adv', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'adblock_block_hits_unsold',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'adblock_all_w_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'adblock_all_wo_nds',     type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',             type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'adblock_partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'adblock_partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id dsp_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => context_on_site_adblock => ['page_id', 'id']],
            ],
        },

        context_on_site_direct => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'type',  type => 'VARCHAR', length   => '20', not_null => TRUE},
                {name => 'limit', type => 'INT',     unsigned => TRUE},
                {name => 'multistate',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'alternative_code', type => 'TEXT',   not_null => TRUE, default  => ''},
                {name => 'border_radius',    type => 'BOOLEAN'},
                {name => 'favicon',      type => 'BOOLEAN', default => 0},
                {name => 'images_first', type => 'BOOLEAN'},
                {name => 'no_sitelinks',         type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'links_underline',      type => 'BOOLEAN', default  => 1},
                {name => 'border_type',          type => 'VARCHAR', length   => '8',},
                {name => 'site_bg_color',        type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'bg_color',             type => 'VARCHAR', length   => '6'},
                {name => 'border_color',         type => 'VARCHAR', length   => '6'},
                {name => 'header_bg_color',      type => 'VARCHAR', length   => '6'},
                {name => 'sitelinks_color',      type => 'VARCHAR', length   => '6'},
                {name => 'title_color',          type => 'VARCHAR', length   => '6'},
                {name => 'text_color',           type => 'VARCHAR', length   => '6'},
                {name => 'url_color',            type => 'VARCHAR', length   => '6'},
                {name => 'url_background_color', type => 'VARCHAR', length   => '6'},
                {name => 'hover_color',          type => 'VARCHAR', length   => '6'},
                {name => 'font_family',          type => 'VARCHAR', length   => '15'},
                {name => 'font_size',            type => 'VARCHAR', length   => '3'},
                {name => 'title_font_size',      type => 'TINYINT', unsigned => TRUE},
                {name => 'adaptive_width',  type => 'VARCHAR', length => '4', not_null => TRUE, default => ''},
                {name => 'adaptive_height', type => 'VARCHAR', length => '4', not_null => TRUE, default => ''},
                {name => 'comment',         type => 'TEXT'},
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT'},
                {name => 'pi_id',  type => 'INT',     unsigned => TRUE},
                {name => 'active', type => 'BOOLEAN', not_null => TRUE, default => 1},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']]]
        },

        context_on_site_direct_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_direct',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_context_on_site_direct => {
            fields => [
                {name => 'dt',                    type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id',           type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',              type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',                type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',           type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'direct_context_shows',  type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'direct_context_clicks', type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'direct_context_all_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'direct_context_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'direct_context_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'direct_context_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => context_on_site_direct => ['campaign_id', 'id']],
            ],
        },

        block_tags => {
            fields => [
                {name => 'page_id', type => 'INT',    unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'caption',    type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'public_id',  type => 'VARCHAR', length   => '21',  not_null => TRUE},
                {name => 'multistate', type => 'BIGINT',  unsigned => TRUE,  not_null => TRUE, default => 0},
            ],
            primary_key => [qw(page_id tag_id)],
            # специально нет foreign_keys, это общая таблица как для СЯ, так и для РСЯ
            indexes => [{fields => ['public_id'], unique => 1}],
        },

        block_tags_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'block_tags',
            elem_table_pk => [qw(page_id tag_id)],
            with_opts     => TRUE,
        },

        # TODO - удалить после выкладки https://st.yandex-team.ru/PI-6097
        # (таблица нужна для того чтобы отработал after_release скрипт)
        context_on_site_direct_tag => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'id_with_campaign_id', type => 'VARCHAR', length => '21', not_null => TRUE},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']]],
            indexes      => [{fields => ['id_with_campaign_id'], unique => 1}],
        },

        context_on_site_stripe => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'title',          type => 'VARCHAR', length   => 255,  not_null => TRUE},
                {name => 'disposition_id', type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'interaction_id', type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'type_id',   type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 1},
                {name => 'animation', type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'comment',     type => 'TEXT'},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']],],
        },

        context_on_site_stripe_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_stripe',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_context_on_site_stripe => {
            fields => [
                {name => 'dt',          type => 'DATE', not_null => TRUE},
                {name => 'campaign_id', type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id'},

                {name => 'stripe_shows',  type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'stripe_clicks', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'stripe_hits',   type => 'INT', unsigned => TRUE, not_null => TRUE},

                {name => 'stripe_all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'stripe_all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},

                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},

                {name => 'stripe_partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'stripe_partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},

                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt currency_id)]}],
            foreign_keys => [[['currency_id'] => currencies => ['id']],],
        },

        statistics_context_on_site_page => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'campaign_id',},
                {name => 'an_fraud_shows',               type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_fraud_clicks',              type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_hits',                type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_direct_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_market_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_mcb_hits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_senthits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_hits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_senthits',        type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_direct_hits',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_context_page_ad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_context_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'mcb_context_hits',             type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'market_context_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt campaign_id)],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']],],
        },

        context_on_site_mcb => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'type', type => 'VARCHAR', length => '20', not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']]]
        },

        context_on_site_mcb_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_mcb',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_context_on_site_mcb => {
            fields => [
                {name => 'dt',                 type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id',        type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',           type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',             type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',        type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'mcb_context_shows',  type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'mcb_context_clicks', type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'mcb_context_all_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'mcb_context_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'mcb_context_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'mcb_context_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => context_on_site_mcb => ['campaign_id', 'id']],
            ],
        },

        context_on_site_market => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']]]
        },

        context_on_site_market_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_market',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_context_on_site_market => {
            fields => [
                {name => 'dt',                    type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id',           type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',              type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',                type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',           type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'market_context_shows',  type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'market_context_clicks', type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'market_context_all_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'market_context_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'market_context_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'market_context_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => context_on_site_market => ['campaign_id', 'id']],
            ],
        },

        context_on_site_market_api => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']]]
        },

        context_on_site_market_api_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_market_api',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_context_on_site_market_api => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id', type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'market_api_context_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'market_api_context_clicks', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'market_api_context_all_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'market_api_context_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'market_api_context_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'market_api_context_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => context_on_site_market_api => ['campaign_id', 'id']],
            ],
        },

        context_on_site_content_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_rtb',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE,
        },

        context_on_site_natural => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'create_date', type => 'DATETIME', default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'caption',     type => 'VARCHAR',  length   => '255', not_null => TRUE, default => ''},
                {name => 'multistate',  type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'geo',     type => 'MEDIUMTEXT'},
                {name => 'comment', type => 'TEXT'},
                {name => 'opts',    type => 'JSON', not_null => TRUE},
                # godmode
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT',},
                {name => 'adfox_block',       type => 'BOOLEAN', not_null => TRUE, default => 0},
                {
                    name     => 'site_version',
                    type     => 'ENUM',
                    values   => ['general', 'turbo', 'turbo_desktop'],
                    not_null => TRUE,
                    default  => 'general'
                },
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => context_on_site_campaign => ['page_id']]]
        },

        context_on_site_natural_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_natural',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_context_on_site_natural => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id', type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'natural_block_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'natural_block_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'natural_block_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_block_hits_own_adv', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_block_hits_unsold',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_all_w_nds',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_all_wo_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',               type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_partner_w_nds',   type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_partner_wo_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',           type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_block_bad_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'natural_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'natural_block_bad_win_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'natural_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'natural_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'natural_bad_win_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'natural_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'natural_bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'natural_bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'natural_block_direct_clicks',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'natural_block_direct_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id dsp_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => context_on_site_natural => ['campaign_id', 'id']],
            ],
        },
    }
);

TRUE;
