package Application::Model::PartnerDB::Contracts;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME);

__PACKAGE__->meta(
    tables => {
        contracts => {
            fields => [
                {name => 'id',          type => 'BIGINT',   unsigned => TRUE, not_null => TRUE,},
                {name => 'multistate',  type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0,},
                {name => 'type',        type => 'VARCHAR',  length   => 32,   not_null => TRUE},
                {name => 'external_id', type => 'VARCHAR',  length   => 32,   not_null => TRUE},
                {name => 'client_id',   type => 'BIGINT',   unsigned => TRUE, not_null => TRUE,},
                {name => 'dt',          type => 'DATETIME', not_null => TRUE, default  => $MYSQL_MIN_DATETIME,},
                {name => 'end_dt',    type => 'DATETIME', null     => TRUE,},
                {name => 'update_dt', type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME,},
                {name => 'contract',  type => 'VARCHAR',  length   => 1024, not_null => TRUE,},
                {name => 'opts',      type => 'JSON',     not_null => TRUE},
                {
                    name      => 'person_id',
                    type      => 'BIGINT',
                    generated => '`contract`->"$.person_id"',
                },
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(multistate)],}, {fields => [qw(client_id)]}, {fields => [qw(dt end_dt)]},],
        },

        contracts_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'contracts',
            elem_table_pk => ['id'],
            with_opts     => {type => 'MEDIUMTEXT'}
        },
    },
);
