package Application::Model::PartnerDB::CookieMatch;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        cookie_match => {
            fields => [
                {name => 'id',       type => 'INT',     unsigned => TRUE,  not_null => TRUE, autoincrement => TRUE,},
                {name => 'comment',  type => 'VARCHAR', length   => '255', default  => '',},
                {name => 'tag',      type => 'VARCHAR', length   => '32',  not_null => TRUE,},
                {name => 'data_key', type => 'VARCHAR', length   => '32',  not_null => TRUE,},
                {name => 'skip_data_key',        type => 'BOOLEAN', not_null => TRUE, default  => 0,},
                {name => 'js_redir',             type => 'BOOLEAN', not_null => TRUE, default  => 0,},
                {name => 'multistate',           type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0,},
                {name => 'trace_back_reference', type => 'BOOLEAN', not_null => TRUE, default  => 0,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(tag)], unique => TRUE},],
        },

        cookie_match_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'cookie_match',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        cookie_match_link_pi => {
            fields =>
              [{name => 'tag_id',}, {name => 'page_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE,},],
            primary_key => ['tag_id', 'page_id'],
            foreign_keys => [[['tag_id'] => cookie_match => ['id']]],
        },

        cookie_match_owners => {
            fields => [{name => 'tag_id',}, {name => 'user_id',},],
            primary_key => ['tag_id', 'user_id'],
            foreign_keys => [[['tag_id'] => cookie_match => ['id']], [['user_id'] => users => ['id']]],
        },
    }
);

TRUE;
