package Application::Model::PartnerDB::Crons;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME);

__PACKAGE__->meta(
    tables => {

        crons => {
            fields => [
                {name => 'id',   type => 'INT',     unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'name', type => 'VARCHAR', length   => 255,  not_null => TRUE,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(name)], unique => TRUE,},],
        },

        crons_raw_stat => {
            fields => [
                {name => 'id',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'cron_id', type => 'INT',    unsigned => TRUE, not_null => TRUE,},
                {name => 'dt',       type => 'DATETIME', not_null => TRUE, default  => $MYSQL_MIN_DATETIME,},
                {name => 'duration', type => 'INT',      unsigned => TRUE, not_null => TRUE,},
                {name => 'ignored',  type => 'BOOLEAN',  not_null => TRUE,},
                {name => 'ok',       type => 'BOOLEAN',  not_null => TRUE,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(cron_id ignored ok)],}, {fields => [qw(dt)],},],
            foreign_keys => [[['cron_id'] => crons => ['id']]],
        },

        cron_auto_stop => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'dt', type => 'DATE',   not_null => TRUE,},
                {name => 'model',        type => 'VARCHAR', length   => 40,   not_null => TRUE,},
                {name => 'user_id',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE,},
                {name => 'keep_working', type => 'BOOLEAN', not_null => TRUE,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(dt model)],}, {fields => [qw(keep_working)],},],
            foreign_keys => [[['user_id'] => users => ['id']]],
        },

    }
);

TRUE;
