package Application::Model::PartnerDB::CustomBKOptions;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        custom_bk_options => {
            fields => [
                {name => 'id',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default       => 0,},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE,},
                {name => 'name',        type => 'VARCHAR',  length   => 32, not_null => FALSE,},
                {name => 'description', type => 'VARCHAR',  length   => 255, not_null => FALSE,},
                {name => 'bk_name',     type => 'VARCHAR',  length   => 255, not_null => FALSE,},
                {name => 'bk_value',    type => 'VARCHAR',  length   => 512, not_null => FALSE,},

            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(name)], unique => 1}, {fields => [qw(bk_name bk_value)], unique => 1},],
        },

        # custom_bk_оptions_action_log => {
        #     type          => 'MultistateActionLog',
        #     elem_table    => 'custom_bk_оptions',
        #     elem_table_pk => ['id'],
        #     with_opts     => TRUE,
        # },
    },
);

TRUE;
