package Application::Model::PartnerDB::DSP;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        dsp => {
            fields => [
                {name => 'id',            type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'owner_id',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'multistate',    type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default       => 0},
                {name => 'short_caption', type => 'VARCHAR', length   => 32,   not_null => TRUE},
                {name => 'url',           type => 'VARCHAR', length   => 1024, not_null => TRUE},
                {name => 'test_url',      type => 'VARCHAR', length   => 1024, not_null => TRUE},
                {name => 'skipnoud',      type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'tag',           type => 'VARCHAR', length   => 32},
                {name => 'data_key',      type => 'VARCHAR', length   => 255,  not_null => TRUE, default       => ''},
                {name => 'show_probability', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 100},
                {name => 'postmoderated',    type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'unmoderated_rtb_auction', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'display_name', type => 'VARCHAR', length => 32, not_null => TRUE, default => ''},
                {name => 'patch',        type => 'JSON'},
                {name => 'is_ssp_allowed', type => 'BOOLEAN', not_null => TRUE, default => 0},
            ],
            primary_key  => ['id'],
            foreign_keys => [[['owner_id'] => users => ['id']]]
        },

        dsp_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'dsp',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        dsp_documentation => {
            fields => [
                {name => 'id',          type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'name',        type => 'VARCHAR', length   => 255,  not_null => TRUE},
                {name => 'description', type => 'TEXT',    not_null => TRUE},
                {name => 'language',   type => 'CHAR',       length   => 2,    not_null => TRUE},
                {name => 'filename',   type => 'VARCHAR',    length   => 255,  not_null => TRUE},
                {name => 'content',    type => 'MEDIUMBLOB', not_null => TRUE},
                {name => 'multistate', type => 'BIGINT',     unsigned => TRUE, not_null => TRUE},
            ],
            primary_key => ['id'],
        },

        dsp_documentation_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'dsp_documentation',
            elem_table_pk => ['id'],
        },

        statistics_dsp => {
            fields => [
                {name => 'dt',     type     => 'DATE', not_null => TRUE},
                {name => 'dsp_id', not_null => TRUE},
                {name => 'campaign_id', type    => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', default => 2},
                {name => 'dsp_shows',             type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'dsp_bids',              type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_hits',              type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'dsp_charging_w_nds',    type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'dsp_charging_wo_nds',   type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'charging_w_nds',        type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'charging_wo_nds',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_real_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_real_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt dsp_id currency_id campaign_id)],
            foreign_keys => [[['dsp_id'] => dsp => ['id']], [['currency_id'] => currencies => ['id']]]
        },

        statistics_dsp_response => {
            fields => [
                {name => 'dt',     type     => 'DATE', not_null => TRUE},
                {name => 'dsp_id', not_null => TRUE},
                {name => 'campaign_id', type => 'INT',    unsigned => TRUE, not_null => TRUE},
                {name => 'error_type',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'errors_sum',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt dsp_id campaign_id error_type)],
            foreign_keys => [[['dsp_id'] => dsp => ['id']],]
        },

        dsp_type => {
            fields => [
                {name => 'dsp_id',},
                {name => 'type_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key => ['dsp_id', 'type_id'],
            foreign_keys => [[['dsp_id'] => dsp => ['id']]]
        },

        block_dsps => {
            fields => [
                {name => 'page_id',  type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'block_id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id'},
                {name => 'show_count', type => 'TINYINT',   unsigned => TRUE,},
                {name => 'interval',   type => 'MEDIUMINT', unsigned => TRUE,},
                {name => 'is_deleted', type => 'BOOLEAN',   not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(page_id block_id dsp_id)],
            foreign_keys => [[['dsp_id'] => dsp => ['id']]]
        },

        block_dsps_unmoderated => {
            fields => [
                {name => 'page_id',  type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'block_id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id'},
            ],
            primary_key  => [qw(page_id block_id dsp_id)],
            foreign_keys => [[['dsp_id'] => dsp => ['id']]],
        },

        dsp_format => {
            fields => [
                {name => 'dsp_id',},
                {name => 'format_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key => ['dsp_id', 'format_id'],
            foreign_keys => [[['dsp_id'] => dsp => ['id']]]
        },
    }
);

TRUE;
