package Application::Model::PartnerDB::DesignTemplates;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME $DESIGN_TYPES $DEFAULT_DESIGN_TYPE);

__PACKAGE__->meta(
    tables => {
        design_templates => {
            fields => [
                {name => 'id',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'page_id',  type => 'INT',    unsigned => TRUE, not_null => TRUE,},
                {name => 'block_id', type => 'INT',    unsigned => TRUE, not_null => TRUE,},
                {
                    name     => 'type',
                    type     => 'ENUM',
                    values   => [sort values %$DESIGN_TYPES],
                    not_null => TRUE,
                    default  => $DEFAULT_DESIGN_TYPE,
                },
                {name => 'caption',     type => 'VARCHAR',  length   => 255,  not_null => TRUE,},
                {name => 'opts',        type => 'JSON',     not_null => TRUE,},
                {name => 'multistate',  type => 'BIGINT',   not_null => TRUE, default  => 0},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_MIN_DATETIME}
            ],
            primary_key => ['id'],
            indexes     => [{fields => ['page_id', 'block_id'], unique => FALSE}],
        },
        design_templates_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'design_templates',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },
    }
);

TRUE;
