package Application::Model::PartnerDB::Distribution;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME $MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {

        distribution_campaign => {
            fields => [
                {name => 'id',      type => 'INT', unsigned => TRUE, not_null => TRUE,},
                {name => 'page_id', type => 'INT', unsigned => TRUE},
                {name => 'owner_id'},
                {name => 'opts',       type => 'JSON',    not_null => TRUE},
                {name => 'caption',    type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',   type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'comment',     type => 'TEXT'},
                {name => 'creator_id'},
                {name => 'patch',        type => 'JSON'},
                {name => 'blocks_limit', type => 'INT', not_null => TRUE, default => 400},
                {name => 'blocks_count', type => 'INT', not_null => TRUE, default => 0},
            ],
            primary_key  => ['id'],
            indexes      => [{fields => [qw(page_id)], unique => TRUE}],
            foreign_keys => [[['owner_id'] => users => ['id']], [['creator_id'] => users => ['id']],],
        },

        distribution_campaign_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'distribution_campaign',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },
    }
);

TRUE;
