package Application::Model::PartnerDB::EventLog;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        event_log => {
            fields => [
                {name => 'id',         type => 'BIGINT', not_null => TRUE, autoincrement => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null      => TRUE, default => 0},
                {name => 'date',      type => 'DATE',     not_null => TRUE},
                {name => 'create_dt', type => 'DATETIME', not_null => TRUE},
                {name => 'create_user_id'},
                {name => 'description', type => 'VARCHAR', length   => 512,  not_null => TRUE, default => ''},
                {name => 'level',       type => 'VARCHAR', length   => 512,  not_null => TRUE},
                {name => 'element',     type => 'VARCHAR', length   => 512,  not_null => FALSE},
                {name => 'type_id',     type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'class_id',    type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'pi_id',       type => 'INT',     unsigned => TRUE},
            ],
            primary_key  => ['id'],
            indexes      => [{fields => ['date']}],
            foreign_keys => [[['create_user_id'] => users => ['id']]]
        },

        event_log_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'event_log',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

    }
);

TRUE;
