package Application::Model::PartnerDB::FastBan;

use qbit;

use base qw(
  QBit::Application::Model::DB::mysql
  );

__PACKAGE__->meta(
    tables => {
        fast_ban => {
            fields => [
                {name => 'id',          type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'model',       type => 'VARCHAR', length   => 512,  not_null => TRUE,},
                {name => 'page_id',     type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'url_md5_hex', type => 'VARCHAR', length   => 32,   not_null => TRUE,},
                {name => 'url',         type => 'VARCHAR', length   => 512,  not_null => TRUE,},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(page_id block_id url_md5_hex)], unique => TRUE}],
        },
    }
);

TRUE;
