package Application::Model::PartnerDB::HourGlass;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        scheduler_instances => {
            fields => [
                {name => 'instance_id',    type => 'VARCHAR',   length   => 128,  not_null => TRUE},
                {name => 'version',        type => 'VARCHAR',   length   => 128,  not_null => TRUE},
                {name => 'heartbeat_time', type => 'TIMESTAMP', not_null => TRUE, default  => 'CURRENT_TIMESTAMP'},
                {name => 'is_main', type => 'TINYINT', length => 1, unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'meta', type => 'VARCHAR', length => 512},
            ],
            primary_key => ['instance_id'],
        },
        scheduled_tasks => {
            fields => [
                {name => 'id',     type => 'INT',     unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'name',   type => 'VARCHAR', length   => 128,  not_null => TRUE},
                {name => 'params', type => 'VARCHAR', length   => 128,  not_null => TRUE},
                {
                    name     => 'status',
                    type     => 'ENUM',
                    values   => [qw(New Starting Running Finished Paused Deleted)],
                    not_null => TRUE,
                    default  => 'New'
                },
                {name => 'instance_id',    type => 'VARCHAR', length => 128},
                {name => 'heartbeat_time', type => 'TIMESTAMP'},
                {name => 'next_run',         type => 'TIMESTAMP', not_null => TRUE, default  => '1970-01-01 03:00:01'},
                {name => 'schedule_hash',    type => 'VARCHAR',   length   => 512,  not_null => TRUE},
                {name => 'job_name_hash',    type => 'VARCHAR',   length   => 128,  not_null => TRUE},
                {name => 'last_start_time',  type => 'TIMESTAMP', not_null => TRUE, default  => '1970-01-01 03:00:01'},
                {name => 'last_finish_time', type => 'TIMESTAMP', not_null => TRUE, default  => '1970-01-01 03:00:01'},
                {
                    name     => 'need_reschedule',
                    type     => 'TINYINT',
                    length   => 1,
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'version', type => 'VARCHAR', length => 128, not_null => TRUE, default => ''},
                {name => 'meta',    type => 'VARCHAR', length => 512},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(name params)], unique => 1}],
        },
    }
);

TRUE;
