package Application::Model::PartnerDB::IntAPI;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        intapi_acl => {
            fields => [
                {name => 'path',       type => 'VARCHAR',    length   => 63},
                {name => 'method',     type => 'VARCHAR',    length   => 63},
                {name => 'acl',        type => 'TEXT'},
                {name => 'acl_cached', type => 'MEDIUMTEXT', not_null => TRUE},
            ],
            primary_key => [qw(path method)],
        },

        intapi_acl_changes => {
            fields => [
                {name => 'id',      type => 'INT',     unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'path',    type => 'VARCHAR', length   => 63},
                {name => 'method',  type => 'VARCHAR', length   => 63},
                {name => 'new_acl', type => 'TEXT'},
                {name => 'user_id'},
                {name => 'dt', type => 'DATETIME', not_null => TRUE},
            ],
            primary_key  => ['id'],
            foreign_keys => [[['user_id'] => users => ['id']]],
            indexes      => [{fields => [qw(path method)]}, {fields => [qw(dt)]}],
        },

        legacy_billing_report => {
            fields => [
                {name => 'rec_update_time', type => 'DATETIME', not_null => TRUE},
                {name => 'page_id',         type => 'INT',      length   => 20, unsigned => TRUE, not_null => TRUE},
                {name => 'date_from',       type => 'DATE',     not_null => TRUE},
                {name => 'date_to',       type => 'DATE'},
                {name => 'aggregator_id', type => 'INT', length => 20, unsigned => TRUE, not_null => TRUE},
            ],
            primary_key => [qw(page_id date_from)],
        },
    }
);

TRUE;
