package Application::Model::PartnerDB::InternalContextOnSite;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        internal_context_on_site_campaign => {
            fields => [
                {name => 'id',          type => 'INT',      unsigned => TRUE, not_null => TRUE},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'site_id',},
                {name => 'caption',              type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'family_filter',        type => 'BOOLEAN', not_null => TRUE,  default  => 0},
                {name => 'from_trigger',         type => 'BOOLEAN', not_null => TRUE,  default  => 0},
                {name => 'behavioral_targeting', type => 'BOOLEAN', not_null => TRUE,  default  => 1},
                {name => 'view_images',          type => 'BOOLEAN', not_null => TRUE,  default  => 1},
                {name => 'reload_timeout',       type => 'TINYINT', unsigned => TRUE,  not_null => TRUE, default => 30},
                {name => 'multistate',           type => 'BIGINT',  unsigned => TRUE,  not_null => TRUE, default => 0},
                {name => 'comment',              type => 'TEXT'},
                {name => 'block_title',     type => 'VARCHAR',  length   => '255', default => ''},
                {name => 'fast_context',    type => 'BOOLEAN',  not_null => TRUE,  default => 1},
                {name => 'only_picture',    type => 'BOOLEAN',  not_null => TRUE,  default => 0},
                {name => 'mobile_app_mode', type => 'TINYINT',  not_null => TRUE,  default => 0},
                {name => 'update_time',     type => 'DATETIME', not_null => TRUE,  default => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',       type => 'DATETIME', not_null => TRUE,  default => $MYSQL_DEFAULT_DATETIME},
                {name => 'page_lang',        type => 'INT',     not_null => TRUE,   unsigned => TRUE, default => 1},
                {name => 'allowed_turbo',    type => 'BOOLEAN', not_null => TRUE,   default  => 1},   ## ??
                {name => 'metrica_counters', type => 'VARCHAR', length   => '1024', not_null => TRUE, default => ''},
                {name => 'unmoderated_rtb_auction', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'performance_tgo_disable', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'blocks_limit',            type => 'INT',     not_null => TRUE, default => 400},
                {name => 'blocks_count',            type => 'INT',     not_null => TRUE, default => 0},
                {
                    name    => 'tier',
                    type    => 'TINYINT',
                    default => 3,
                },
                {name => 'opts',       type => 'JSON',   not_null => TRUE},
                {name => 'creator_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'patch', type => 'JSON'},
            ],
            primary_key  => ['id'],
            foreign_keys => [[['site_id'] => internal_site => ['id']], [['creator_id'] => users => ['id']],],
        },

        internal_context_on_site_campaign_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'internal_context_on_site_campaign',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        internal_context_on_site_campaign_banner_lang => {
            fields       => [{name => 'campaign_id'}, {name => 'language_id'}],
            primary_key  => [qw(campaign_id language_id)],
            foreign_keys => [
                [['campaign_id'] => internal_context_on_site_campaign => ['id']],
                [['language_id'] => bk_language                       => ['id']]
            ],
        },

        internal_context_on_site_mirrors => {
            fields => [{name => 'campaign_id'}, {name => 'domain', type => 'VARCHAR', length => 64, not_null => 1}],
            primary_key  => [qw(campaign_id domain)],
            foreign_keys => [[['campaign_id'] => internal_context_on_site_campaign => ['id']]]
        },

        internal_context_on_site_ya_categories => {
            fields => [
                {name => 'campaign_id'},
                {name => 'category_id'},
                {name => 'probability', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id category_id)],
            foreign_keys => [
                [['campaign_id'] => internal_context_on_site_campaign => ['id']],
                [['category_id'] => ya_categories                     => ['id']],
            ]
        },

        internal_context_on_site_block_seq => {
            fields =>
              [{name => 'campaign_id'}, {name => 'next_block_id', type => 'INT', unsigned => 1, not_null => TRUE}],
            primary_key  => ['campaign_id'],
            foreign_keys => [[['campaign_id'] => internal_context_on_site_campaign => ['id']]]
        },

        internal_context_on_site_rtb_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_rtb',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => {type => 'MEDIUMTEXT'},
        },

        internal_context_on_site_direct => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'type',  type => 'VARCHAR', length   => '20', not_null => TRUE},
                {name => 'limit', type => 'INT',     unsigned => TRUE},
                {name => 'multistate',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'alternative_code', type => 'TEXT',   not_null => TRUE, default  => ''},
                {name => 'border_radius',    type => 'BOOLEAN',},
                {name => 'favicon',              type => 'BOOLEAN', default  => 0},
                {name => 'no_sitelinks',         type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'images_first',         type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'links_underline',      type => 'BOOLEAN', default  => 1},
                {name => 'border_type',          type => 'VARCHAR', length   => '8',},
                {name => 'site_bg_color',        type => 'VARCHAR', length   => '6', not_null => TRUE},
                {name => 'bg_color',             type => 'VARCHAR', length   => '6'},
                {name => 'border_color',         type => 'VARCHAR', length   => '6'},
                {name => 'header_bg_color',      type => 'VARCHAR', length   => '6'},
                {name => 'sitelinks_color',      type => 'VARCHAR', length   => '6'},
                {name => 'title_color',          type => 'VARCHAR', length   => '6'},
                {name => 'text_color',           type => 'VARCHAR', length   => '6'},
                {name => 'url_color',            type => 'VARCHAR', length   => '6'},
                {name => 'url_background_color', type => 'VARCHAR', length   => '6'},
                {name => 'hover_color',          type => 'VARCHAR', length   => '6'},
                {name => 'font_family',          type => 'VARCHAR', length   => '15'},
                {name => 'font_size',            type => 'VARCHAR', length   => '3'},
                {name => 'title_font_size',      type => 'TINYINT', unsigned => TRUE},
                {name => 'adaptive_width',       type => 'VARCHAR', length   => 4, not_null => TRUE, default => ''},
                {name => 'adaptive_height',      type => 'VARCHAR', length   => 4, not_null => TRUE, default => ''},
                {name => 'comment',           type => 'TEXT'},
                {name => 'active',            type => 'BOOLEAN', not_null => TRUE, default => 1},
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT'},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => internal_context_on_site_campaign => ['id']]]
        },

        internal_context_on_site_direct_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'internal_context_on_site_direct',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_internal_context_on_site_direct => {
            fields => [
                {name => 'dt',                    type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id',           type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',              type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',                type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',           type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'direct_context_shows',  type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'direct_context_clicks', type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'direct_context_all_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'direct_context_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => internal_context_on_site_direct => ['campaign_id', 'id']],
            ],
        },

        # TODO - удалить после выкладки https://st.yandex-team.ru/PI-6097
        # (таблица нужна для того чтобы отработал after_release скрипт)
        internal_context_on_site_direct_tag => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'id_with_campaign_id', type => 'VARCHAR', length => '21', not_null => TRUE},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => internal_context_on_site_campaign => ['id']]],
            indexes      => [{fields => ['id_with_campaign_id'], unique => 1}],
        },

        internal_context_on_site_stripe => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'title',          type => 'VARCHAR', length   => 255,  not_null => TRUE},
                {name => 'disposition_id', type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'interaction_id', type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'type_id',   type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 1},
                {name => 'animation', type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'comment',     type => 'TEXT'},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => internal_context_on_site_campaign => ['id']],],
        },

        internal_context_on_site_stripe_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'internal_context_on_site_stripe',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_internal_context_on_site_stripe => {
            fields => [
                {name => 'dt',          type => 'DATE', not_null => TRUE},
                {name => 'campaign_id', type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id'},

                {name => 'stripe_shows',  type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'stripe_clicks', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'stripe_hits',   type => 'INT', unsigned => TRUE, not_null => TRUE},

                {name => 'stripe_all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'stripe_all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},

                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt currency_id)]}],
            foreign_keys => [[['currency_id'] => currencies => ['id']],],
        },

        statistics_internal_context_on_site_page => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'campaign_id',},
                {name => 'an_fraud_shows',               type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_fraud_clicks',              type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_hits',                type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_direct_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_market_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_mcb_hits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_senthits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_hits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_senthits',        type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_direct_hits',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_context_page_ad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_context_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id)],
            foreign_keys => [[['campaign_id'] => internal_context_on_site_campaign => ['id']],],
        },

        internal_context_on_site_content => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'create_date', type => 'DATETIME', default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'caption',     type => 'VARCHAR',  length   => '255', not_null => TRUE, default => ''},
                {name => 'multistate',  type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'geo',     type => 'MEDIUMTEXT'},
                {name => 'comment', type => 'TEXT'},
                {name => 'opts',    type => 'JSON', not_null => TRUE},
                # godmode
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT',},
                {
                    name     => 'site_version',
                    type     => 'ENUM',
                    values   => ['general', 'turbo', 'turbo_desktop'],
                    not_null => TRUE,
                    default  => 'general'
                },
                {name => 'adfox_block', type => 'BOOLEAN', not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id id)],
            indexes      => [{fields => ['id']}],
            foreign_keys => [[['campaign_id'] => internal_context_on_site_campaign => ['id']]]
        },

        internal_context_on_site_content_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'internal_context_on_site_content',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_internal_context_on_site_content => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id', type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'content_block_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'content_block_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'content_block_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'content_block_hits_own_adv', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'content_block_hits_unsold',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'content_all_w_nds',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'content_all_wo_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',               type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'content_block_bad_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'content_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'content_block_bad_win_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'content_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'content_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'content_bad_win_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'content_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'content_block_direct_clicks',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'content_block_direct_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id dsp_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => internal_context_on_site_content => ['campaign_id', 'id']],
            ],
        },

        internal_context_on_site_natural => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'create_date', type => 'DATETIME', default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'caption',     type => 'VARCHAR',  length   => '255', not_null => TRUE, default => ''},
                {name => 'multistate',  type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'geo',     type => 'MEDIUMTEXT'},
                {name => 'comment', type => 'TEXT'},
                {name => 'opts',    type => 'JSON', not_null => TRUE},
                # godmode
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT',},
                {
                    name     => 'site_version',
                    type     => 'ENUM',
                    values   => ['general', 'turbo', 'turbo_desktop'],
                    not_null => TRUE,
                    default  => 'general'
                },
                {name => 'adfox_block', type => 'BOOLEAN', not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => internal_context_on_site_campaign => ['id']]]
        },

        internal_context_on_site_natural_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'internal_context_on_site_natural',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_internal_context_on_site_natural => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id', type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'natural_block_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'natural_block_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'natural_block_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_block_hits_own_adv', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_block_hits_unsold',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_all_w_nds',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_all_wo_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',               type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'natural_block_bad_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'natural_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'natural_block_bad_win_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'natural_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'natural_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'natural_bad_win_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'natural_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'natural_block_direct_clicks',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'natural_block_direct_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id dsp_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => internal_context_on_site_natural => ['campaign_id', 'id']],
            ],
        },

    }
);

TRUE;
