package Application::Model::PartnerDB::InternalMobileApp;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        internal_mobile_app => {
            fields => [
                {name => 'id',          type => 'INT',      unsigned => TRUE, not_null => TRUE},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'type',        type => 'TINYINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'store_id',    type => 'VARCHAR',  length   => 255},
                {name => 'store_url',   type => 'VARCHAR',  length   => 255},
                {name => 'caption',     type => 'VARCHAR',  length   => 255,  not_null => TRUE},
                {name => 'multistate',           type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'family_filter',        type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'behavioral_targeting', type => 'BOOLEAN', not_null => TRUE, default  => 1},
                {name => 'view_images',          type => 'BOOLEAN', not_null => TRUE, default  => 1},
                {name => 'comment',              type => 'TEXT'},
                {name => 'block_title',  type => 'VARCHAR',  length   => '255', default => ''},
                {name => 'fast_context', type => 'BOOLEAN',  not_null => TRUE,  default => 1},
                {name => 'only_picture', type => 'BOOLEAN',  not_null => TRUE,  default => 0},
                {name => 'update_time',  type => 'DATETIME', not_null => TRUE,  default => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',    type => 'DATETIME', not_null => TRUE,  default => $MYSQL_DEFAULT_DATETIME},
                {name => 'false_click',  type => 'BOOLEAN',  not_null => TRUE,  default => 0},
                {name => 'from_trigger', type => 'BOOLEAN',  not_null => TRUE,  default => 0},
                {name => 'unmoderated_rtb_auction', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'performance_tgo_disable', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {
                    name    => 'tier',
                    type    => 'TINYINT',
                    default => 3,
                },
                {name => 'opts',       type => 'JSON',   not_null => TRUE},
                {name => 'creator_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'patch',        type => 'JSON'},
                {name => 'blocks_limit', type => 'INT', not_null => TRUE, default => 400},
                {name => 'blocks_count', type => 'INT', not_null => TRUE, default => 0},
            ],
            primary_key  => ['id'],
            indexes      => [{fields => ['multistate']}],
            foreign_keys => [[['creator_id'] => users => ['id']],],
        },

        internal_mobile_app_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'internal_mobile_app',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        internal_mobile_app_rtb_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_rtb',
            elem_table_pk => ['campaign_id', 'id'],
            with_opts     => TRUE,
        },

        internal_mobile_app_block_seq => {
            fields =>
              [{name => 'application_id'}, {name => 'next_block_id', type => 'INT', unsigned => 1, not_null => 1}],
            primary_key  => ['application_id'],
            foreign_keys => [[['application_id'] => internal_mobile_app => ['id']]]
        },

        internal_mobile_app_bk_language => {
            fields      => [{name => 'application_id'}, {name => 'language_id'}],
            primary_key => [qw(application_id language_id)],
            foreign_keys =>
              [[['application_id'] => internal_mobile_app => ['id']], [['language_id'] => bk_language => ['id']]],
        },
    }
);

TRUE;
