package Application::Model::PartnerDB::Inviter;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        invites => {
            fields => [
                {name => 'id',    type => 'CHAR',    length   => 32,   not_null => TRUE},
                {name => 'type',  type => 'TINYINT', unsigned => TRUE, not_null => TRUE},
                {name => 'lang',  type => 'CHAR',    length   => 2,    not_null => TRUE},
                {name => 'email', type => 'VARCHAR', length   => 150,  not_null => TRUE},
                {name => 'manager_id'},
                {name => 'partner_id',  not_null => FALSE},
                {name => 'create_date', type     => 'DATETIME', not_null => TRUE},
                {name => 'multistate',  type     => 'BIGINT', not_null => TRUE, unsigned => TRUE},
                {name => 'opts', type => 'JSON', not_null => TRUE},
            ],
            primary_key  => ['id'],
            foreign_keys => [[['manager_id'] => users => ['id']], [['partner_id'] => users => ['id']],]
        },
    }
);

1;
