package Application::Model::PartnerDB::KvStoreFrontend;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {

        kv_store_frontend => {
            fields => [
                {name => 'id',      type => 'BIGINT',     unsigned => TRUE,  not_null => TRUE, autoincrement => TRUE},
                {name => 'user_id', type => 'BIGINT',     unsigned => TRUE,  not_null => TRUE},
                {name => 'key',     type => 'VARCHAR',    length   => '255', not_null => TRUE},
                {name => 'value',   type => 'MEDIUMTEXT', not_null => TRUE},
                {name => 'create_time', type => 'DATETIME', not_null => TRUE},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE}
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(user_id key)], unique => 1}],
            foreign_keys => [[['user_id'] => users => ['id']]],
        },

    }
);

TRUE;
