package Application::Model::PartnerDB::MDS;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        mds => {
            fields => [
                {name => 'id',        type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'url',       type => 'VARCHAR',  length   => 1024, not_null => TRUE},
                {name => 'user_id',   type => 'BIGINT',   unsigned => TRUE, not_null => TRUE},
                {name => 'upload_dt', type => 'DATETIME', not_null => TRUE},
                {name => 'file_name', type => 'VARCHAR', length => 256, not_null => TRUE},
            ],
            primary_key  => ['id'],
            foreign_keys => [[['user_id'] => users => ['id']]]
        },
        mds_avatars => {
            fields => [
                {name => 'id',        type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'user_id',   type => 'BIGINT',   unsigned => TRUE, not_null => TRUE},
                {name => 'group_id',  type => 'INT',      unsigned => TRUE, not_null => TRUE,},
                {name => 'imagename', type => 'VARCHAR',  length   => 256,  not_null => TRUE},
                {name => 'md5',       type => 'CHAR',     length   => 32,   not_null => TRUE},
                {name => 'update_dt', type => 'DATETIME', not_null => TRUE},
                {name => 'links',     type => 'JSON',     not_null => TRUE},
                {name => 'block_cnt', type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default       => 0,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(user_id md5)], unique => 1}, {fields => [qw(update_dt block_cnt)]},],
            foreign_keys => [[['user_id'] => users => ['id']]]
        },
    }
);

TRUE;
