package Application::Model::PartnerDB::MailNotification;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME);

__PACKAGE__->meta(
    tables => {
        mail_notification => {
            fields => [
                {
                    name          => 'id',
                    type          => 'BIGINT',
                    unsigned      => TRUE,
                    not_null      => TRUE,
                    autoincrement => TRUE,
                    comment       => 'job identifier',
                },
                {
                    name     => 'multistate',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0,
                    comment  => 'current state of job',
                },
                {
                    name     => 'type',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0,
                    comment  => 'job type',
                },
                {
                    name     => 'user_id',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'recipient identifier'
                },
                {
                    name     => 'period',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_NULL => FALSE,
                    comment  => 'job period parameter'
                },
                {
                    name     => 'create_date',
                    type     => 'DATETIME',
                    not_null => TRUE,
                    default  => $MYSQL_MIN_DATETIME,
                    comment  => 'job creation date'
                },
                {
                    name     => 'date_x',
                    type     => 'DATETIME',
                    not_null => TRUE,
                    default  => $MYSQL_MIN_DATETIME,
                    comment  => 'job planned start date'
                },
                {name => 'opts', type => 'JSON', not_null => TRUE, comment => 'additional options and stashed values'},
            ],
            primary_key  => ['id'],
            foreign_keys => [[[qw(user_id)] => users => [qw(id)]]],
            indexes => [{fields => [qw(multistate date_x)]},],
        },

        mail_notification_timeout => {
            fields => [
                {
                    name     => 'to',
                    type     => 'VARCHAR',
                    length   => 512,
                    not_null => TRUE,
                },
                {
                    name     => 'dt',
                    type     => 'DATETIME',
                    not_null => TRUE,
                    default  => $MYSQL_MIN_DATETIME,
                },
            ],
            primary_key => ['to'],
        },
    }
);

TRUE;
