package Application::Model::PartnerDB::Migrations;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        migrations => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'source_type', type => 'ENUM', values => [qw(perl java)], not_null => TRUE, default => 'perl'},
                {name => 'order_type', type => 'ENUM', values => [qw(before after)], not_null => TRUE},
                {
                    name     => 'db_type',
                    type     => 'ENUM',
                    values   => [qw(mysql clickhouse)],
                    not_null => TRUE,
                    default  => 'mysql'
                },
                {name => 'name',        type => 'VARCHAR',   length   => 256,  not_null => TRUE},
                {name => 'time_start',  type => 'TIMESTAMP', not_null => TRUE, default  => 'CURRENT_TIMESTAMP'},
                {name => 'time_stop',   type => 'TIMESTAMP', not_null => TRUE, default  => 'CURRENT_TIMESTAMP'},
                {name => 'result_code', type => 'BIGINT',    not_null => FALSE,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(name order_type)], unique => 1}]
        },
    }
);

TRUE;
