package Application::Model::PartnerDB::MobileApp;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME $MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        mobile_app => {
            fields => [
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'type',        type => 'TINYINT',  unsigned => TRUE},
                {name => 'store_id',    type => 'VARCHAR',  length   => 255},
                {name => 'store_url',   type => 'VARCHAR',  length   => 255},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'comment',    type => 'TEXT'},
                {name => 'waiting_moderation', type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'done_moderation',    type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'opts',               type => 'JSON',     not_null => TRUE},
                {
                    name      => 'is_mobile_mediation',
                    type      => 'BOOLEAN',
                    not_null  => TRUE,
                    generated => 'opts->"$.is_mobile_mediation"',
                    stored    => TRUE,
                }
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(type store_id)],}, {fields => ['multistate']}],
        },

        mobile_app_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'mobile_app',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        mobile_app_owner => {
            fields => [
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'app_id'},
                {name => 'user_id'},
            ],
            primary_key  => [qw(id)],
            indexes      => [{fields => [qw(app_id user_id)], unique => TRUE}],
            foreign_keys => [[['app_id'] => mobile_app => ['id']], [['user_id'] => users => ['id']]]
        },

        mobile_app_settings => {
            fields => [
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE,},
                {name => 'application_id'},
                {name => 'owner_id'},
                {name => 'context_page_id', type => 'INT',      unsigned => TRUE},
                {name => 'create_date',     type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'caption',         type => 'VARCHAR',  length   => 255, not_null => TRUE},
                {name => 'multistate',      type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'family_filter',        type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'from_trigger',         type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'behavioral_targeting', type => 'BOOLEAN', not_null => TRUE,  default => 1},
                {name => 'view_images',          type => 'BOOLEAN', not_null => TRUE,  default => 1},
                {name => 'comment',              type => 'TEXT'},
                {name => 'block_title',          type => 'VARCHAR', length   => '255', default => ''},
                {name => 'fast_context',         type => 'BOOLEAN', not_null => TRUE,  default => 1},
                {name => 'only_picture',         type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'cpa',         type => 'INT',      unsigned => TRUE},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',   type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'false_click', type => 'BOOLEAN',  not_null => TRUE, default => 0},
                {name => 'unmoderated_rtb_auction', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'performance_tgo_disable', type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'blocks_limit',            type => 'BIGINT',  not_null => TRUE, default => 200},
                {name => 'blocks_count',            type => 'BIGINT',  not_null => TRUE, default => 0},
                {
                    name    => 'tier',
                    type    => 'TINYINT',
                    default => 3,
                },
                {name => 'opts', type => 'JSON', not_null => TRUE},
                {
                    name      => 'is_mobile_mediation',
                    type      => 'BOOLEAN',
                    not_null  => FALSE,
                    generated => 'opts->"$.is_mobile_mediation"',
                    stored    => TRUE,
                },
                {name => 'creator_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'patch',      type => 'JSON'}
            ],
            primary_key  => ['id'],
            foreign_keys => [
                [['application_id'] => mobile_app => ['id']],
                [['owner_id']       => users      => ['id']],
                [['creator_id']     => users      => ['id']],
            ],
            indexes => [{fields => ['multistate']}, {fields => ['context_page_id'], unique => TRUE}],
        },

        mobile_app_settings_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'mobile_app_settings',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        mobile_app_rtb_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'context_on_site_rtb',
            elem_table_pk => ['campaign_id', 'id'],
            with_opts     => TRUE,
        },

        mobile_app_block_seq => {
            fields =>
              [{name => 'context_page_id'}, {name => 'next_block_id', type => 'INT', unsigned => 1, not_null => 1}],
            primary_key  => ['context_page_id'],
            foreign_keys => [[['context_page_id'] => mobile_app_settings => ['context_page_id']]]
        },

        statistics_mobile_app_page => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'context_page_id',},
                {name => 'an_mobile_rtb_cover_hits',        type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_mobile_rtb_cover_senthits',    type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_mobile_rtb_cover_direct_hits', type => 'INT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt context_page_id)],
            foreign_keys => [[['context_page_id'] => mobile_app_settings => ['context_page_id']],],
        },

        mobile_app_bk_language => {
            fields       => [{name => 'context_page_id'}, {name => 'language_id'}],
            primary_key  => [qw(context_page_id language_id)],
            foreign_keys => [
                [['context_page_id'] => mobile_app_settings => ['context_page_id']],
                [['language_id']     => bk_language         => ['id']]
            ],
        },

        monetizers => {
            fields => [
                {name => 'id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'caption', type => 'VARCHAR', length   => 255,  not_null => TRUE},
            ],
            primary_key => ['id'],
        },
    }
);

TRUE;
