package Application::Model::PartnerDB::Moderation;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        moderation_queue => {
            fields => [
                {name => 'id',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'create_date', type => 'DATE',   not_null => TRUE},
                {name => 'moderation_date', type => 'DATE',    not_null => TRUE},
                {name => 'page_id',         type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'domain_id',       type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'product',         type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'type',            type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'multistate',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'comment',         type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
            ],
            primary_key => ['id'],
        },

        moderation_rel_site_mirrors => {
            fields => [
                {name => 'qid', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'id',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {
                    name     => 'moderation_status',
                    type     => 'ENUM',
                    values   => ['new', 'approved', 'rejected'],
                    not_null => TRUE,
                    default  => 'new'
                },
                {name => 'relative_model', type => 'VARCHAR', length => '255', not_null => TRUE, default => 0},
            ],
            primary_key => ['qid', 'id'],
            foreign_keys => [[['qid'] => moderation_queue => ['id']]]
        },

        moderation_queue_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'moderation_queue',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        moderation_reason => {
            fields => [
                {name => 'id',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'group_id',   type => 'INT',    unsigned => TRUE, not_null => TRUE, default       => 999999},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default       => 0},
                {
                    name     => 'create_date',
                    type     => 'DATETIME',
                    not_null => TRUE,
                    not_null => TRUE,
                    default  => $MYSQL_DEFAULT_DATETIME
                },
                {name => 'manager_txt', type => 'VARCHAR', length   => 512,  not_null => FALSE, i18n => TRUE},
                {name => 'partner_txt', type => 'VARCHAR', length   => 512,  not_null => FALSE, i18n => TRUE},
                {name => 'timeout',     type => 'BIGINT',  not_null => TRUE, default  => -1},
                {name => 'owner_id'},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(id group_id)], unique => TRUE,},],
            foreign_keys => [[['owner_id'] => users => ['id']]],
        },
        moderation_reason_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'moderation_reason',
            elem_table_pk => ['id'],
            with_opts     => TRUE,
        },
    },
);

TRUE;
