package Application::Model::PartnerDB::News;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        news => {
            fields => [
                {name => 'id', type => 'BIGINT', not_null => TRUE, autoincrement => TRUE},
                {name => 'user_id'},
                {name => 'change_date', type => 'TIMESTAMP', not_null => TRUE},
                {name => 'date',        type => 'DATE',      not_null => TRUE},
                {name => 'title',       type => 'VARCHAR',   length   => 1000, not_null => TRUE},
                {name => 'text',              type => 'MEDIUMTEXT'},
                {name => 'show_on_main_page', type => 'BOOLEAN', not_null => TRUE},
            ],
            primary_key => ['id'],
            indexes     => [{fields => ['change_date']}, {fields => ['date']}],
            foreign_keys => [[['user_id'] => users => ['id']]]
        }
    }
);

TRUE;
