package Application::Model::PartnerDB::Notification;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        notification => {
            fields => [
                {name => 'id',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default       => 0,},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, not_null => TRUE,},
                {name => 'type', type => 'ENUM', values => [qw(custom auto)], not_null => TRUE, default => 'custom',},
                {name => 'short_name', type => 'VARCHAR', length => 16, not_null => TRUE},
                {
                    name     => 'view_type',
                    type     => 'ENUM',
                    values   => [qw(default common_offer custom_link survey top)],
                    not_null => TRUE,
                    default  => 'default',
                },
                {name => 'ttl', type => 'INT', unsigned => TRUE, not_null => TRUE,},
                {name => 'caption',             type => 'VARCHAR', length => 255,  not_null => TRUE,  i18n => TRUE,},
                {name => 'icon_id',             type => 'VARCHAR', length => 255,  not_null => TRUE,},
                {name => 'message',             type => 'VARCHAR', length => 1000, not_null => TRUE,  i18n => TRUE,},
                {name => 'button_caption',      type => 'VARCHAR', length => 255,  not_null => FALSE, i18n => TRUE,},
                {name => 'url',                 type => 'VARCHAR', length => 255,  not_null => FALSE,},
                {name => 'expectation_caption', type => 'VARCHAR', length => 255,  not_null => FALSE, i18n => TRUE,},
                {name => 'expected_growth', type => 'INT',  unsigned => TRUE, not_null => FALSE, default => 0,},
                {name => 'opts',            type => 'JSON', not_null => TRUE,},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(short_name)], unique => TRUE}],
        },
        notification_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'notification',
            elem_table_pk => ['id'],
            with_opts     => TRUE,
        },
        user_notifications => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE,},
                {name => 'notification_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE,},
                {name => 'user_id',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE,},
                {name => 'multistate',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0,},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE,},
                {name => 'accessor',    type => 'VARCHAR',  length   => 255, not_null => FALSE,},
                {name => 'opts',        type => 'JSON',     not_null => TRUE,},
            ],
            primary_key  => ['id'],
            indexes      => [{fields => ['user_id']}, {fields => ['notification_id', 'user_id']}],
            foreign_keys => [[['user_id'] => users => ['id']], [['notification_id'] => notification => ['id']]],
        },
    }
);

TRUE;
