package Application::Model::PartnerDB::OutDoor;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME $MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {

        outdoor => {
            fields => [
                {name => 'id',      type => 'INT', unsigned => TRUE, not_null => TRUE,},
                {name => 'page_id', type => 'INT', unsigned => TRUE},
                {name => 'owner_id'},
                {name => 'opts', type => 'JSON', not_null => TRUE},
                {
                    name      => 'caption',
                    type      => 'VARCHAR',
                    length    => 255,
                    not_null  => TRUE,
                    generated => 'opts->"$.caption"'
                },
                {name => 'multistate',   type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'blocks_limit', type => 'BIGINT', not_null => TRUE, default  => 200},
                {name => 'blocks_count', type => 'BIGINT', not_null => TRUE, default  => 0},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',   type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {
                    name    => 'tier',
                    type    => 'TINYINT',
                    default => 3,
                },
                {name => 'comment',            type => 'TEXT'},
                {name => 'waiting_moderation', type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'creator_id',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'patch',              type => 'JSON'},
            ],
            primary_key  => ['id'],
            indexes      => [{fields => [qw(page_id)], unique => TRUE}],
            foreign_keys => [[['owner_id'] => users => ['id']], [['creator_id'] => users => ['id']],],
        },

        outdoor_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'outdoor',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        outdoor_block_seq => {
            fields =>
              [{name => 'page_id'}, {name => 'next_block_id', type => 'INT', unsigned => TRUE, not_null => TRUE}],
            primary_key  => ['page_id'],
            foreign_keys => [[['page_id'] => outdoor => ['page_id']]]
        },

        outdoor_block => {
            fields => [
                {name => 'page_id'},
                {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                {name => 'opts', type => 'JSON', not_null => TRUE},
                {
                    name      => 'caption',
                    type      => 'VARCHAR',
                    length    => 255,
                    not_null  => TRUE,
                    generated => 'opts->"$.caption"'
                },
                {
                    name      => 'resolution',
                    type      => 'VARCHAR',
                    length    => 11,
                    not_null  => TRUE,
                    generated => 'opts->"$.resolution"'
                },
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'comment',     type => 'TEXT'},
                {name => 'waiting_moderation', type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'is_custom_bk_data',  type => 'BOOLEAN',  not_null => TRUE, default => 0},
                {name => 'bk_data',            type => 'MEDIUMTEXT',},
            ],
            primary_key  => [qw(page_id id)],
            foreign_keys => [[['page_id'] => outdoor => ['page_id']],],
            indexes      => [{fields => ['multistate']}, {fields => [qw(id)]}],
        },

        outdoor_block_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'outdoor_block',
            elem_table_pk => ['page_id', 'id'],
            with_opts     => TRUE
        },

        statistics_outdoor => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'page_id',},
                {name => 'currency_id',     type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'an_fraud_shows',  type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'an_fraud_clicks', type => 'INT',     unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt page_id currency_id)],
            foreign_keys => [[['page_id'] => outdoor => ['id']],],
        },

        statistics_outdoor_block => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'page_id',     type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'dsp_id',      type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'tag_id',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'outdoor_block_shows', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'outdoor_block_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'outdoor_block_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'outdoor_block_hits_own_adv', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'outdoor_block_hits_unsold',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'outdoor_block_direct_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'outdoor_block_direct_clicks',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'outdoor_all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'outdoor_all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',     type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'outdoor_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'outdoor_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'outdoor_block_bad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'outdoor_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'outdoor_block_bad_win_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'outdoor_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'outdoor_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'outdoor_bad_win_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'outdoor_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'outdoor_bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'outdoor_bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'outdoor_block_win_hits',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'outdoor_block_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'outdoor_block_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
            ],
            primary_key  => [qw(dt page_id block_id dsp_id currency_id tag_id)],
            indexes      => [{fields => [qw(page_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['page_id', 'block_id'] => outdoor_block => ['page_id', 'id']],
            ],
        },
    }
);

TRUE;
