package Application::Model::PartnerDB::PICategories;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        picategories => {
            fields => [
                {name => 'page_id',     type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE,},
                {name => 'category_id', type => 'INT',     not_null => TRUE},
                {name => 'cpm',         type => 'DECIMAL', length   => 10,   decimals => 3,}
            ],
            primary_key => ['page_id', 'block_id', 'category_id',],
        },
        picategories_dict => {
            fields => [
                {name => 'category_id', type => 'INT',     not_null => TRUE},
                {name => 'parent_id',   type => 'INT',     not_null => TRUE},
                {name => 'level',       type => 'INT',     not_null => TRUE},
                {name => 'name',        type => 'VARCHAR', length   => 64, not_null => TRUE, i18n => TRUE},
            ],
            primary_key => ['category_id']
        }
    }
);

TRUE;
