package Application::Model::PartnerDB::Pages;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($TABLE_PAGE_MODELS $MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        pages => {
            fields => [
                {name => 'allowed_amp',   type => 'BOOLEAN', not_null => TRUE, default => 1},
                {name => 'allowed_turbo', type => 'BOOLEAN', not_null => TRUE, default => 1},
                {name => 'blocks_limit',  type => 'BIGINT',  not_null => TRUE, default => 200},
                {name => 'blocks_count',  type => 'BIGINT',  not_null => TRUE, default => 0},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => FALSE, default => ''},
                {name => 'create_date',  type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'domain_id',    type => 'BIGINT'},
                {name => 'from_trigger', type => 'BOOLEAN',  not_null => TRUE, default  => 0},
                {name => 'id',           type => 'INT',      unsigned => TRUE, not_null => TRUE},
                {
                    name     => 'model',
                    type     => 'ENUM',
                    values   => [sort keys %$TABLE_PAGE_MODELS],
                    not_null => TRUE,
                },
                {name => 'multistate', type     => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'opts',       type     => 'JSON',   not_null => TRUE},
                {name => 'owner_id',   not_null => FALSE,},
                {name => 'page_id',                 type => 'BIGINT',  unsigned => TRUE, not_null => TRUE,},
                {name => 'unmoderated_rtb_auction', type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                {name => 'creator_id',  type => 'BIGINT',   not_null => TRUE}
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(page_id)], unique => TRUE,},],
            foreign_keys => [[['owner_id'] => users => ['id']],],
        },
    }
);

TRUE;
