package Application::Model::PartnerDB::PagesBS;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        pagesbs => {
            fields => [
                {name => 'page_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},    # Page.PageID
                {name => 'domain', type => 'VARCHAR', length => 255, not_null => TRUE},       # Page.Domain
                {name => 'state', type => 'TINYINT', not_null => TRUE},                       # Page.State
                {name => 'mirrors',         type => 'TEXT'},    # PartnerPage.DomainList
                {name => 'excludeddomains', type => 'TEXT'},    # конкуренты PartnerPage.DomainFilter
                {name => 'opt_dontshowbehavior', type => 'BOOLEAN', not_null => TRUE},   # Page.Options like '%nobehav%'
                {name => 'opt_dontshowsex', type => 'BOOLEAN', not_null => TRUE},        # Page.Options like '%family%
                {name => 'opt_readonly',    type => 'BOOLEAN', not_null => TRUE},        # Page.ReadOnly
                {name => 'srch_lang',       type => 'VARCHAR', length   => 2},
                {name => 'partner',         type => 'TINYINT'},
                {name => 'nopicturedomains', type => 'BOOLEAN'},
                {name => 'target_type',      type => 'TINYINT'},
            ],
            primary_key => [qw(page_id)],
        },
    }
);

TRUE;
