package Application::Model::PartnerDB::QualityCoef;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        quality_def_coef => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'k',  type => 'INT',  unsigned => TRUE, not_null => TRUE},
            ],
            primary_key => ['dt'],
        },
        quality_pages_coef => {
            fields => [
                {name => 'dt',      type => 'DATE', not_null => TRUE},
                {name => 'page_id', type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'k',       type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'orders',  type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'ses_num', type => 'INT',  unsigned => TRUE, not_null => TRUE},
                {name => 'days',    type => 'INT',  unsigned => TRUE, not_null => TRUE},
            ],
            primary_key => ['dt', 'page_id'],
            indexes => [{fields => ['page_id', 'dt']}],
        },
    }
);

TRUE;
