package Application::Model::PartnerDB::Queue;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        queue => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},

                # дата-время постановки задачи. Тут всегда есть значение
                {name => 'add_dt', type => 'DATETIME', not_null => TRUE},

                # дата-время начала выполнения, но не дата-время постановки задачи
                # после того как задача поставлена тут находится NULL до тех пор пока задача не пошла в работу
                {name => 'start_dt', type => 'DATETIME', not_null => FALSE},

                # дата время заверешения, NULL пока задача не завершена
                {name => 'end_dt',      type => 'DATETIME', not_null => FALSE},
                {name => 'method_type', type => 'TINYINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'group_id', type => 'INT'},

                # json серилизованные параметры, которые будут переданы в метод с именем из поля 'method_name'
                {name => 'params', type => 'TEXT'},

                # user_id - uid пользователя, кто запустил
                # не сделал foreign key, так как тут может быть NULL
                {name => 'user_id', type => 'BIGINT', unsigned => TRUE, not_null => FALSE},

                # статус процесса (новый, сейчас выполняется, успешно завершен, завершен с ошибкой, остановлен)
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},

                # Серелизованный объект Time::ETA, с помощью которого прогнозируется время выполнения задачи
                {name => 'time_eta', type => 'TEXT'},

                # Для записи лога (если задача завершалась с ошибкой, то тут смотреть в чем была ошибка)
                {name => 'log', type => 'TEXT'},

                # Данные, используемые в сообщении об ошибке в интерфейсе
                {name => 'error_data', type => 'TEXT'},

                # Результат выполнения
                {name => 'result', type => 'TEXT'},

                # Число попыток повторного выполнения
                {name => 'tries', type => 'INT', not_null => TRUE, default => 0},

                {name => 'grabbed_by',    type => 'TEXT'},
                {name => 'grabbed_at',    type => 'DATETIME'},
                {name => 'grabbed_until', type => 'DATETIME'},
            ],
            primary_key => ['id'],
            indexes     => [{fields => ['multistate'], type => 'HASH'}],
        },
    }
);

TRUE;
