package Application::Model::PartnerDB::SSP;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        ssp_seller => {
            fields => [
                {
                    name     => 'id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'id'
                },
                {
                    name     => 'user_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'ssp user_id'
                },
                {
                    name     => 'client_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'ssp client_id'
                },
                {
                    name     => 'name',
                    type     => 'VARCHAR',
                    length   => '128',
                    not_null => TRUE,
                    comment  => 'Имя SSP'
                },
                {
                    name     => 'tmpl_ssp_mobile_app',
                    type     => 'TEXT',
                    not_null => TRUE,
                    comment  => 'Шаблон для приложения'
                },
                {
                    name     => 'tmpl_ssp_context_rtb',
                    type     => 'TEXT',
                    not_null => TRUE,
                    comment  => 'Шаблон для приложения'
                },
                {
                    name     => 'tmpl_ssp_video_app',
                    type     => 'TEXT',
                    not_null => TRUE,
                    comment  => 'Шаблон для видео'
                },
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(user_id)]}, {fields => [qw(client_id)]},],
        },

        ssp_impression_log => {
            fields => [
                {name => 'date', type => 'DATE', not_null => TRUE, comment => 'Дата записи'},
                {
                    name     => 'source_type',
                    type     => 'VARCHAR',
                    length   => '16',
                    not_null => TRUE,
                    comment  => 'Тип показа - enum("media", "app-media", "video", "app-video")'
                },
                {
                    name     => 'hits',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'хиты по источнику за день'
                },
                {
                    name     => 'seller_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'SSP ID'
                },
                {
                    name     => 'page_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'Page ID'
                },
                {
                    name     => 'source_token_id',
                    type     => 'VARCHAR',
                    length   => '128',
                    not_null => TRUE,
                    comment  => 'ID токена места показа',
                },
                {
                    name      => 'source_token',
                    type      => 'VARCHAR',
                    length    => '1024',
                    not_null  => TRUE,
                    comment   => 'токена места показа',
                    collation => 'utf8_bin'
                },
                {
                    name     => 'source_domain',
                    type     => 'VARCHAR',
                    length   => '255',
                    not_null => TRUE,
                    comment  => 'сайт показа, или апп_ид'
                },
                {
                    name     => 'source_domain_formats',
                    type     => 'VARCHAR',
                    length   => '255',
                    not_null => TRUE,
                    comment  => 'запрашиваемые форматы, цсв'
                },
                {
                    name      => 'source_app',
                    type      => 'VARCHAR',
                    length    => '255',
                    not_null  => TRUE,
                    comment   => 'приложение показа (апп ид)',
                    collation => 'utf8_bin'
                },
                {
                    name     => 'source_app_os',
                    type     => 'VARCHAR',
                    length   => '128',
                    not_null => TRUE,
                    comment  => 'Версия ОС'
                },
                {name => 'application_id', type => 'BIGINT', unsigned => TRUE, not_null => FALSE},
                {name => 'site_id',        type => 'BIGINT', unsigned => TRUE, not_null => FALSE},
            ],
            primary_key => ['date', 'seller_id', 'source_token_id', 'source_type', 'page_id'],
            indexes      => [{fields => [qw(date)]}, {fields => [qw(application_id)]}, {fields => [qw(source_token)]}],
            foreign_keys => [
                [['seller_id']      => ssp_seller      => ['id']],
                [['site_id']        => ssp_site        => ['id']],
                [['application_id'] => ssp_application => ['id']],
            ],
        },

        ssp_site => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {
                    name     => 'domain',
                    type     => 'VARCHAR',
                    length   => 255,
                    not_null => TRUE,
                    comment  => 'domain from impression',
                },
                {name => 'name', type => 'VARCHAR', length => 255, not_null => TRUE, comment => 'name'},
            ],
            primary_key => ['id'],
        },

        ssp_application => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {
                    name      => 'bundle_id',
                    type      => 'VARCHAR',
                    length    => 255,
                    not_null  => TRUE,
                    comment   => 'Bundle ID',
                    collation => 'utf8_bin'
                },
                {
                    name      => 'apple_id',
                    type      => 'VARCHAR',
                    length    => 255,
                    not_null  => TRUE,
                    comment   => 'Apple ID (opt)',
                    collation => 'utf8_bin'
                },
                {name => 'store_id', type => 'INT', unsigned => TRUE, not_null => TRUE, comment => '1-gplay,2-itunes'},
                {name => 'store_app_url', type => 'VARCHAR', length => 4000, not_null => TRUE, comment => 'store link'},
                {name => 'name',          type => 'VARCHAR', length => 255,  not_null => TRUE, comment => 'App name'},
            ],
            primary_key => ['id'],
            indexes     => [{fields => [qw(bundle_id apple_id)], unique => 1}],
        },

        ssp_link_mobile_app => {
            fields => [
                {name => 'id',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default       => 0},
                {
                    name     => 'application_id',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'ssp application id'
                },
                {
                    name     => 'mobile_app_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => FALSE,
                    default  => undef,
                    comment  => 'ssp_mobile_app.id'
                },
                {
                    name      => 'tokens',
                    type      => 'VARCHAR',
                    length    => '10000',
                    not_null  => TRUE,
                    comment   => 'json, source tokens',
                    collation => 'utf8_bin',
                },
                {
                    name     => 'weight',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'текущая посещаемость'
                },
                {name => 'seller_id', type => 'INT', unsigned => TRUE, not_null => TRUE, comment => 'SSP ID'},
                {
                    name     => 'comment',
                    type     => 'VARCHAR',
                    length   => '4000',
                    not_null => FALSE,
                    comment  => ''
                },
                {
                    name     => 'moderation_reason_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => FALSE,
                    comment  => 'Расшифровка модерации'
                },
            ],
            primary_key => ['id'],
            indexes     => [
                {fields => [qw(seller_id application_id)], unique => 1},
                {fields => [qw(application_id)]},
                {fields => [qw(mobile_app_id)]},
                {fields => [qw(tokens)]}
            ],
            foreign_keys => [
                [['application_id'] => ssp_application         => ['id']],
                [['mobile_app_id']  => ssp_mobile_app_settings => ['id']],
                [['seller_id']      => ssp_seller              => ['id']],
            ],
        },

        ssp_link_mobile_app_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'ssp_link_mobile_app',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        ssp_link_context_rtb => {
            fields => [
                {name => 'id',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default       => 0},
                {
                    name     => 'site_id',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => FALSE,
                    default  => undef,
                    comment  => 'ssp site id'
                },
                {
                    name     => 'context_rtb_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => FALSE,
                    default  => undef,
                    comment  => 'ssp_context_rtb.id'
                },
                {
                    name     => 'tokens',
                    type     => 'VARCHAR',
                    length   => '10000',
                    not_null => TRUE,
                    comment  => 'json, source tokens'
                },
                {
                    name     => 'weight',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'текущая посещаемость'
                },
                {name => 'seller_id', type => 'INT', unsigned => TRUE, not_null => TRUE, comment => 'SSP ID'},
                {
                    name     => 'comment',
                    type     => 'VARCHAR',
                    length   => '4000',
                    not_null => FALSE,
                    comment  => ''
                },
                {
                    name     => 'moderation_reason_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => FALSE,
                    comment  => 'Расшифровка модерации'
                },
            ],
            primary_key => ['id'],
            indexes =>
              [{fields => [qw(seller_id site_id)], unique => 1}, {fields => [qw(context_rtb_id)], unique => 1}],
            foreign_keys => [
                [['seller_id']      => ssp_seller                   => ['id']],
                [['site_id']        => ssp_site                     => ['id']],
                [['context_rtb_id'] => ssp_context_on_site_campaign => ['id']],
            ],
        },

        ssp_link_context_rtb_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'ssp_link_context_rtb',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        ssp_link_video_app => {
            fields => [
                {name => 'id',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default       => 0},
                {
                    name     => 'application_id',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'ssp application id'
                },
                {
                    name     => 'video_app_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => FALSE,
                    default  => undef,
                    comment  => 'ssp_video_app.id'
                },
                {
                    name      => 'tokens',
                    type      => 'VARCHAR',
                    length    => '10000',
                    not_null  => TRUE,
                    comment   => 'json, source tokens',
                    collation => 'utf8_bin',
                },
                {
                    name     => 'weight',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    comment  => 'текущая посещаемость'
                },
                {name => 'seller_id', type => 'INT', unsigned => TRUE, not_null => TRUE, comment => 'SSP ID'},
                {
                    name     => 'comment',
                    type     => 'VARCHAR',
                    length   => '4000',
                    not_null => FALSE,
                    comment  => ''
                },
                {
                    name     => 'moderation_reason_id',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => FALSE,
                    comment  => 'Расшифровка модерации'
                },
            ],
            primary_key => ['id'],
            indexes     => [
                {fields => [qw(seller_id application_id)], unique => 1},
                {fields => [qw(application_id)]},
                {fields => [qw(video_app_id)]},
                {fields => [qw(tokens)]}
            ],
            foreign_keys => [
                [['application_id'] => ssp_application   => ['id']],
                [['video_app_id']   => ssp_video_an_site => ['id']],
                [['seller_id']      => ssp_seller        => ['id']],
            ],
        },

        ssp_link_video_app_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'ssp_link_video_app',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        (
            map {
                $_->[0] => {
                    fields => [
                        {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE,},
                        {
                            name     => 'create_date',
                            type     => 'DATETIME',
                            not_null => TRUE,
                            default  => $MYSQL_DEFAULT_DATETIME
                        },
                        {name => 'page_id', type => 'BIGINT', unsigned => TRUE, not_null => FALSE},
                        {name => 'comment', type => 'TEXT'},
                        {name => 'owner_id'},
                        {name => 'source_id'},
                        {name => 'multistate',  type => 'BIGINT',  unsigned => TRUE,  not_null => TRUE, default => 0},
                        {name => 'block_title', type => 'VARCHAR', length   => '255', default  => ''},
                        {name => 'view_images', type => 'BOOLEAN', not_null => TRUE,  default  => 1},
                        {name => 'behavioral_targeting', type => 'BOOLEAN', not_null => TRUE, default => 1},
                        {
                            name     => 'banner_langs',
                            type     => 'VARCHAR',
                            length   => 255,
                            not_null => TRUE,
                            default  => '["by","en","kz","ru","uk"]'
                        },

                        {name => 'cpa',             type => 'INT',     unsigned => TRUE, not_null => TRUE},
                        {name => 'mobile_app_mode', type => 'TINYINT', not_null => TRUE, default  => 0},
                        {name => 'fast_context',    type => 'BOOLEAN', not_null => TRUE, default  => 0},
                        {name => 'only_picture',    type => 'BOOLEAN', not_null => TRUE, default  => 0},
                        {name => 'family_filter',   type => 'BOOLEAN', not_null => TRUE, default  => 1},
                        {name => 'seller_id',       type => 'INT',     unsigned => TRUE, not_null => TRUE},
                        {
                            name     => 'update_time',
                            type     => 'DATETIME',
                            not_null => TRUE,
                            default  => $MYSQL_DEFAULT_DATETIME
                        },
                        {name => 'send_time', type => 'DATETIME', not_null => TRUE, default => $MYSQL_DEFAULT_DATETIME},
                        {name => 'creator_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                        {name => 'patch',      type => 'JSON'},
                    ],
                    primary_key  => [qw(id)],
                    indexes      => [{fields => ['page_id'], unique => TRUE}],
                    foreign_keys => [
                        [['owner_id', 'seller_id'] => ssp_seller => ['user_id', 'id']],
                        [['source_id']  => $_->[1] => ['id']],
                        [['creator_id'] => users   => ['id']],
                    ]
                  }
              } (
                ['ssp_context_on_site_campaign', 'ssp_site'],
                ['ssp_mobile_app_settings',      'ssp_application'],
                ['ssp_video_an_site',            'ssp_application']
              )
        ),

        (
            map {
                scalar "${_}_action_log" => {
                    type          => 'MultistateActionLog',
                    elem_table    => $_,
                    elem_table_pk => ['id'],
                    with_opts     => TRUE
                  }
              } qw(ssp_context_on_site_campaign ssp_mobile_app_settings ssp_video_an_site)
        ),

        (
            map {
                scalar "${_}_mirrors" => {
                    fields =>
                      [{name => 'campaign_id'}, {name => 'domain', type => 'VARCHAR', length => 64, not_null => 1},],
                    primary_key  => [qw(campaign_id domain)],
                    foreign_keys => [[['campaign_id'] => $_ => ['id']],]
                  }
              } qw(
              ssp_context_on_site_campaign
              ssp_mobile_app_settings
              ssp_video_an_site
              )
        ),

        (
            map {
                $_->[0] => {
                    fields => [
                        {name => 'campaign_id'},
                        {name => 'id', type => 'INT', unsigned => 1, not_null => 1},
                        {name => 'create_date', type => 'DATETIME', default => $MYSQL_DEFAULT_DATETIME},
                        {name => 'caption',     type => 'VARCHAR',  length  => '255', not_null => TRUE, default => ''},
                        {name => 'direct_block', type => 'VARCHAR', length   => '32', not_null => TRUE},
                        {name => 'media_block',  type => 'VARCHAR', length   => '12', not_null => TRUE},
                        {name => 'limit',        type => 'INT',     unsigned => TRUE},
                        {name => 'multistate', type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, default => 0},
                        {name => 'geo',        type => 'MEDIUMTEXT'},
                        {name => 'blind',      type => 'TINYINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                        {name => 'strategy',   type => 'SMALLINT', unsigned => TRUE, not_null => TRUE, default => 1},
                        {name => 'mincpm',     type => 'VARCHAR',  length   => '16', not_null => TRUE, default => '0'},
                        {name => 'alternative_code',     type => 'TEXT',    not_null => TRUE},
                        {name => 'border_radius',        type => 'BOOLEAN',},
                        {name => 'border_type',          type => 'VARCHAR', length   => '8'},
                        {name => 'favicon',              type => 'BOOLEAN', default  => 0},
                        {name => 'no_sitelinks',         type => 'BOOLEAN', default  => 0},
                        {name => 'links_underline',      type => 'BOOLEAN', default  => TRUE},
                        {name => 'site_bg_color',        type => 'VARCHAR', length   => '6'},
                        {name => 'bg_color',             type => 'VARCHAR', length   => '6'},
                        {name => 'border_color',         type => 'VARCHAR', length   => '6'},
                        {name => 'header_bg_color',      type => 'VARCHAR', length   => '6'},
                        {name => 'sitelinks_color',      type => 'VARCHAR', length   => '6'},
                        {name => 'title_color',          type => 'VARCHAR', length   => '6'},
                        {name => 'text_color',           type => 'VARCHAR', length   => '6'},
                        {name => 'url_color',            type => 'VARCHAR', length   => '6'},
                        {name => 'url_background_color', type => 'VARCHAR', length   => '6'},
                        {name => 'hover_color',          type => 'VARCHAR', length   => '6'},
                        {name => 'font_family',          type => 'VARCHAR', length   => '15'},
                        {name => 'font_size',            type => 'VARCHAR', length   => '3'},
                        {name => 'title_font_size',      type => 'TINYINT', unsigned => TRUE},
                        {name => 'adaptive_width',  type => 'VARCHAR', length => 4, not_null => TRUE, default => ''},
                        {name => 'adaptive_height', type => 'VARCHAR', length => 4, not_null => TRUE, default => ''},
                        {name => 'comment',         type => 'TEXT'},
                        {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
                        {name => 'bk_data',           type => 'MEDIUMTEXT',},
                        {name => 'adfox_block',       type => 'BOOLEAN', not_null => TRUE, default => 0},
                        {name => 'show_video',        type => 'BOOLEAN', not_null => TRUE, default => 0},
                        {name => 'media_active',      type => 'BOOLEAN',},
                        {name => 'media_blocked',     type => 'BOOLEAN',},
                        {name => 'media_cpm',     type => 'SMALLINT', unsigned => TRUE,},
                        {name => 'text_active',   type => 'BOOLEAN',},
                        {name => 'text_blocked',  type => 'BOOLEAN',},
                        {name => 'text_cpm',      type => 'SMALLINT', unsigned => TRUE,},
                        {name => 'video_active',  type => 'BOOLEAN',},
                        {name => 'video_blocked', type => 'BOOLEAN',},
                        {name => 'video_cpm',     type => 'SMALLINT', unsigned => TRUE,},
                        {name => 'is_custom_format_direct', type => 'BOOLEAN', not_null => TRUE,  default => 0},
                        {name => 'horizontal_align',        type => 'BOOLEAN', not_null => FALSE, default => 1},
                        {name => 'block_type',              type => 'VARCHAR', length   => '18'},
                        {name => 'callouts',                type => 'BOOLEAN'},
                        {name => 'opts', type => 'JSON', not_null => TRUE},
                    ],
                    primary_key  => [qw(campaign_id id)],
                    foreign_keys => [[['campaign_id'] => $_->[1] => ['page_id']]]
                  }
              } (
                ['ssp_context_on_site_rtb', 'ssp_context_on_site_campaign'],
                ['ssp_mobile_app_rtb',      'ssp_mobile_app_settings'],
                ['ssp_video_an_site_rtb',   'ssp_video_an_site']
              )
        ),

        (
            map {
                scalar "${_}_action_log" => {
                    type          => 'MultistateActionLog',
                    elem_table    => $_,
                    elem_table_pk => ['campaign_id', 'id'],
                    with_opts     => TRUE
                  }
              } qw(ssp_context_on_site_rtb ssp_mobile_app_rtb ssp_video_an_site_rtb)
        ),

        statistics_ssp_context_rtb_page => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'page_id',},
                {name => 'an_fraud_shows',               type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_fraud_clicks',              type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_hits',                type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_direct_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_market_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_mcb_hits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_senthits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_hits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_senthits',        type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_direct_hits',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_context_page_ad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_context_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'mcb_context_hits',             type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'market_context_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt page_id)],
            foreign_keys => [[['page_id'] => ssp_context_on_site_campaign => ['page_id']]],
        },

        statistics_ssp_context_rtb_rtb => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'page_id',},
                {name => 'block_id',},
                {name => 'dsp_id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',},
                {name => 'rtb_block_shows',         type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_shows_own_adv', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits',          type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits_own_adv',  type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits_unsold',   type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_all_w_nds',           type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_all_wo_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',               type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_partner_w_nds',       type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_partner_wo_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',           type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_bad_shows',     type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_block_bad_win_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'rtb_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_bad_win_price_w_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'rtb_bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_block_direct_clicks', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_direct_shows',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt page_id block_id dsp_id currency_id)],
            indexes      => [{fields => [qw(page_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['page_id', 'block_id'] => ssp_context_on_site_rtb => ['campaign_id', 'id']],
            ],
        },

        statistics_ssp_mobile_app_page => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'page_id'},
                {name => 'an_ssp_mobile_rtb_cover_hits',        type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_ssp_mobile_rtb_cover_senthits',    type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_ssp_mobile_rtb_cover_direct_hits', type => 'INT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt page_id)],
            foreign_keys => [[['page_id'] => ssp_mobile_app_settings => ['page_id']]]
        },

        statistics_ssp_mobile_app_rtb => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'page_id',},
                {name => 'block_id'},
                {name => 'dsp_id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',},
                {name => 'ssp_mobile_rtb_block_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'ssp_mobile_rtb_block_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'ssp_mobile_rtb_block_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'ssp_mobile_rtb_block_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'ssp_mobile_rtb_block_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'ssp_mobile_rtb_all_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'ssp_mobile_rtb_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'ssp_mobile_rtb_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'ssp_mobile_rtb_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt page_id block_id dsp_id currency_id)],
            indexes      => [{fields => [qw(page_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['page_id', 'block_id'] => ssp_mobile_app_rtb => ['campaign_id', 'id']],
            ],
        },

        statistics_ssp_video_app_page => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'page_id',},
                {name => 'an_fraud_shows',               type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_fraud_clicks',              type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_hits',                type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_direct_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_market_hits',         type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_mcb_hits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_cover_senthits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_hits',            type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_senthits',        type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'an_rtb_cover_direct_hits',     type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_context_page_ad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_context_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'mcb_context_hits',             type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'market_context_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt page_id)],
            foreign_keys => [[['page_id'] => ssp_video_an_site => ['page_id']]],
        },

        statistics_ssp_video_app_rtb => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'page_id',},
                {name => 'block_id'},
                {name => 'dsp_id',          type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',     type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'rtb_block_shows', type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_shows_own_adv', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits',         type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits_own_adv', type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_hits_unsold',  type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_all_w_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_all_wo_nds',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',              type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',             type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_partner_w_nds',      type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_partner_wo_nds',     type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',          type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',         type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_bad_shows',    type => 'INT',    unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_block_bad_shows_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_block_bad_win_hits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_block_bad_win_hits_own_adv',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'rtb_block_bad_win_hits_unsold',
                    type     => 'INT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_bad_win_price_w_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_bad_win_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'bad_win_price_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'bad_win_price_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'rtb_bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'rtb_bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'bad_win_partner_price_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'rtb_block_direct_clicks', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'rtb_block_direct_shows',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt page_id block_id dsp_id currency_id)],
            indexes      => [{fields => [qw(page_id block_id dt)]}, {fields => [qw(dsp_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['page_id', 'block_id'] => ssp_video_an_site_rtb => ['campaign_id', 'id']],
            ],
        },
    }
);

TRUE;
