package Application::Model::PartnerDB::SearchOnSite;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME $MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        search_on_site_campaign => {
            fields => [
                {name => 'id',          type => 'INT',      unsigned => TRUE, not_null => TRUE},
                {name => 'page_id',     type => 'INT',      unsigned => TRUE},
                {name => 'create_date', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'domain_id',},
                {name => 'owner_id',},
                {name => 'caption',        type => 'VARCHAR', length   => '255', not_null => TRUE, default => ''},
                {name => 'family_filter',  type => 'BOOLEAN', not_null => TRUE,  default  => 1},
                {name => 'reload_timeout', type => 'TINYINT', unsigned => TRUE,  not_null => TRUE, default => 30},
                {name => 'multistate',     type => 'BIGINT',  unsigned => TRUE,  not_null => TRUE, default => 0},
                {name => 'comment',        type => 'TEXT'},
                {name => 'block_title',          type => 'VARCHAR', length   => '255', default => ''},
                {name => 'mobile_app_mode',      type => 'TINYINT', not_null => TRUE,  default => 0},
                {name => 'pi_id',                type => 'INT',     unsigned => TRUE},
                {name => 'market_api',           type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'yandex_xml',           type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'user_synchronization', type => 'BOOLEAN', not_null => TRUE,  default => 0},
                {name => 'blocks_limit',         type => 'BIGINT',  not_null => TRUE,  default => 200},
                {name => 'blocks_count',         type => 'BIGINT',  not_null => TRUE,  default => 0},
                {name => 'tag_id',               type => 'INT',     unsigned => TRUE,},
                {name => 'update_time', type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'send_time',   type => 'DATETIME', not_null => TRUE, default  => $MYSQL_DEFAULT_DATETIME},
                {name => 'page_lang',   type => 'INT',      not_null => TRUE, unsigned => TRUE, default => 1},
                {name => 'metrica_counters', type => 'VARCHAR', length => '1024', not_null => TRUE, default => ''},
                {
                    name    => 'tier',
                    type    => 'TINYINT',
                    default => 3,
                },
                {name => 'creator_id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE},
                {name => 'opts',       type => 'JSON',   not_null => TRUE},
                {name => 'patch',      type => 'JSON'},
            ],
            primary_key  => ['id'],
            indexes      => [{fields => [qw(page_id)], unique => TRUE,},],
            foreign_keys => [
                [['domain_id']  => site  => ['id']],
                [['owner_id']   => users => ['id']],
                [['creator_id'] => users => ['id']],
            ]
        },

        search_on_site_campaign_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'search_on_site_campaign',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        search_on_site_campaign_banner_lang => {
            fields      => [{name => 'campaign_id'}, {name => 'language_id'}],
            primary_key => [qw(campaign_id language_id)],
            foreign_keys =>
              [[['campaign_id'] => search_on_site_campaign => ['id']], [['language_id'] => bk_language => ['id']]],
        },

        search_on_site_mirrors => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'campaign_id'},
                {name => 'domain', type => 'VARCHAR', length => 64, not_null => 1},
                {name => 'multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'auto',       type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'create_date',        type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'waiting_moderation', type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(campaign_id domain)], unique => 1}],
            foreign_keys => [[['campaign_id'] => search_on_site_campaign => ['id']]]
        },

        search_on_site_block_seq => {
            fields => [{name => 'campaign_id'}, {name => 'next_block_id', type => 'INT', unsigned => 1, not_null => 1}],
            primary_key  => ['campaign_id'],
            foreign_keys => [[['campaign_id'] => search_on_site_campaign => ['page_id']]]
        },

        search_on_site_direct => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'type',  type => 'VARCHAR', length   => '10', not_null => TRUE},
                {name => 'limit', type => 'INT',     unsigned => TRUE},
                {name => 'multistate',    type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'border_radius', type => 'BOOLEAN', default  => 0},
                {name => 'favicon',              type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'no_sitelinks',         type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'links_underline',      type => 'BOOLEAN', not_null => TRUE, default  => 1},
                {name => 'border_type',          type => 'VARCHAR', length   => '8',  not_null => TRUE},
                {name => 'site_bg_color',        type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'bg_color',             type => 'VARCHAR', length   => '6'},
                {name => 'border_color',         type => 'VARCHAR', length   => '6'},
                {name => 'header_bg_color',      type => 'VARCHAR', length   => '6'},
                {name => 'sitelinks_color',      type => 'VARCHAR', length   => '6'},
                {name => 'title_color',          type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'text_color',           type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'url_color',            type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'url_background_color', type => 'VARCHAR', length   => '6'},
                {name => 'hover_color',          type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'font_family',          type => 'VARCHAR', length   => '15'},
                {name => 'font_size',            type => 'VARCHAR', length   => '3'},
                {name => 'title_font_size',      type => 'TINYINT', unsigned => TRUE},
                {name => 'comment',              type => 'TEXT'},
                {name => 'is_custom_bk_data',    type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'bk_data',              type => 'MEDIUMTEXT'},
                {name => 'pi_id', type => 'INT', unsigned => TRUE},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => search_on_site_campaign => ['page_id']]]
        },

        search_on_site_direct_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'search_on_site_direct',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_search_on_site_direct => {
            fields => [
                {name => 'dt',                   type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id',          type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',             type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',               type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',          type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'direct_search_shows',  type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'direct_search_clicks', type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'direct_search_all_w_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'direct_search_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'direct_search_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'direct_search_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => search_on_site_direct => ['campaign_id', 'id']],
            ],
        },

        search_on_site_premium => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'caption', type => 'VARCHAR', length => '255', not_null => TRUE, default => ''},
                {name => 'type',  type => 'VARCHAR', length   => '10', not_null => TRUE},
                {name => 'limit', type => 'INT',     unsigned => TRUE},
                {name => 'multistate',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'border_radius',   type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'favicon',         type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'no_sitelinks',    type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'links_underline', type => 'BOOLEAN', not_null => TRUE, default  => 1},
                {name => 'border_type',     type => 'VARCHAR', length   => '8',  not_null => TRUE},
                {name => 'site_bg_color',   type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'bg_color',        type => 'VARCHAR', length   => '6'},
                {name => 'border_color',    type => 'VARCHAR', length   => '6'},
                {name => 'header_bg_color', type => 'VARCHAR', length   => '6'},
                {name => 'sitelinks_color', type => 'VARCHAR', length   => '6'},
                {name => 'title_color',       type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'text_color',        type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'url_color',         type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'hover_color',       type => 'VARCHAR', length   => '6',  not_null => TRUE},
                {name => 'font_family',       type => 'VARCHAR', length   => '15'},
                {name => 'font_size',         type => 'VARCHAR', length   => '3'},
                {name => 'title_font_size',   type => 'TINYINT', unsigned => TRUE},
                {name => 'comment',           type => 'TEXT'},
                {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default  => 0},
                {name => 'bk_data',           type => 'MEDIUMTEXT'},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => search_on_site_campaign => ['page_id']]]
        },

        search_on_site_premium_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'search_on_site_premium',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_search_on_site_premium => {
            fields => [
                {name => 'dt',                     type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id',            type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',               type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',                 type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',            type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'premium_shows',          type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'premium_clicks',         type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'premium_all_w_nds',      type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'premium_all_wo_nds',     type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_w_nds',              type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds',             type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'premium_partner_w_nds',  type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'premium_partner_wo_nds', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_w_nds',          type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds',         type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => search_on_site_premium => ['campaign_id', 'id']],
            ],
        },

        statistics_search_on_site_page => {
            fields => [
                {name => 'dt', type => 'DATE', not_null => TRUE},
                {name => 'campaign_id',},
                {name => 'premium_page_ad_shows',       type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_search_page_ad_shows', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'direct_search_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'premium_hits',                type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'mcb_search_hits',             type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'market_search_hits',          type => 'INT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key  => [qw(dt campaign_id)],
            foreign_keys => [[['campaign_id'] => search_on_site_campaign => ['page_id']],],
        },

        search_on_site_mcb => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'type', type => 'VARCHAR', length => '20', not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => search_on_site_campaign => ['page_id']]]
        },

        search_on_site_mcb_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'search_on_site_mcb',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_search_on_site_mcb => {
            fields => [
                {name => 'dt',                   type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id',          type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',             type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',               type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',          type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'mcb_search_shows',     type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'mcb_search_clicks',    type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'mcb_search_all_w_nds', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'mcb_search_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'mcb_search_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'mcb_search_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => search_on_site_mcb => ['campaign_id', 'id']],
            ],
        },

        search_on_site_market => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => search_on_site_campaign => ['page_id']]]
        },

        search_on_site_market_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'search_on_site_market',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_search_on_site_market => {
            fields => [
                {name => 'dt',                   type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id',          type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',             type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'tag_id',               type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id',          type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'market_search_shows',  type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'market_search_clicks', type => 'INT',     unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'market_search_all_w_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'market_search_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'market_search_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'market_search_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id tag_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => search_on_site_market => ['campaign_id', 'id']],
            ],
        },

        search_on_site_market_api => {
            fields => [
                {name => 'campaign_id'},
                {name => 'id', type => 'INT', unsigned => TRUE, not_null => TRUE},
                {name => 'multistate', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(campaign_id id)],
            foreign_keys => [[['campaign_id'] => search_on_site_campaign => ['page_id']]]
        },

        search_on_site_market_api_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'search_on_site_market',
            elem_table_pk => [qw(campaign_id id)],
            with_opts     => TRUE
        },

        statistics_search_on_site_market_api => {
            fields => [
                {name => 'dt',          type => 'DATE',    not_null => TRUE},
                {name => 'campaign_id', type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'block_id',    type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'currency_id', type => 'TINYINT', unsigned => TRUE, not_null => TRUE, default => 2},
                {name => 'market_api_search_shows', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'market_api_search_clicks', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'market_api_search_all_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'market_api_search_all_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'all_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'all_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'market_api_search_partner_w_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {
                    name     => 'market_api_search_partner_wo_nds',
                    type     => 'BIGINT',
                    unsigned => TRUE,
                    not_null => TRUE,
                    default  => 0
                },
                {name => 'partner_w_nds',  type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'partner_wo_nds', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => [qw(dt campaign_id block_id currency_id)],
            indexes      => [{fields => [qw(campaign_id block_id dt)]}],
            foreign_keys => [
                [['currency_id'] => currencies => ['id']],
                [['campaign_id', 'block_id'] => search_on_site_market_api => ['campaign_id', 'id']],
            ],
        },

    }
);

TRUE;
