package Application::Model::PartnerDB::Sender;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        sender_log => {
            fields => [
                {name => 'id', type => 'BIGINT', unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'create_time', type => 'TIMESTAMP', not_null => TRUE, default  => 'CURRENT_TIMESTAMP',},
                {name => 'template',    type => 'VARCHAR',   length   => 255,  not_null => TRUE},
                {name => 'recipient',   type => 'JSON',      not_null => TRUE},
                {name => 'response',    type => 'JSON',      not_null => TRUE},
                {name => 'message_id',  type => 'VARCHAR',   length   => 255,  not_null => TRUE},
                {name => 'status',      type => 'JSON'},
                {name => 'opts',        type => 'JSON'},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => [qw(template message_id)], unique => 1},],
        },
    },
);

TRUE;
