package Application::Model::PartnerDB::SimpleNotification;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        simple_notification => {
            fields => [
                {name => 'message',    type => 'VARCHAR', length   => 1024, not_null => TRUE, i18n          => TRUE},
                {name => 'id',         type => 'INT',     unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default       => 0},
                {name => 'ntype',      type => 'VARCHAR', length => 32,   not_null => TRUE, default => 'default'},
                {name => 'icon',       type => 'VARCHAR', length => 1024, not_null => TRUE, default => ''},
                {name => 'link',       type => 'VARCHAR', length => 1024, not_null => TRUE, default => ''},
                {name => 'short_name', type => 'VARCHAR', length => 255,  not_null => TRUE},
                {name => 'title', type => 'VARCHAR', length => 1024, not_null => TRUE, default => '', i18n => TRUE},
                {name => 'button_text', type => 'VARCHAR', length => 255, not_null => TRUE, i18n => TRUE},

            ],
            primary_key => ['id'],
        },
        simple_notification_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'simple_notification',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },
        simple_notification_roles => {
            fields => [
                {name => 'role_id',         type => 'SMALLINT', unsigned => TRUE, not_null => TRUE},
                {name => 'notification_id', type => 'INT',      unsigned => TRUE, not_null => TRUE},
            ],
            primary_key => ['role_id', 'notification_id'],
            foreign_keys => [[['notification_id'] => simple_notification => ['id']]],
        },
        simple_notification_custom_link => {
            fields => [
                {name => 'login', type => 'VARCHAR', length => 1024, not_null => TRUE},
                {name => 'link',  type => 'VARCHAR', length => 1024, not_null => TRUE, default => ''},
            ],
            primary_key => ['login'],
        },
    }
);

TRUE;
