package Application::Model::PartnerDB::Site;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

use PiConstants qw($MYSQL_MIN_DATETIME $MYSQL_DEFAULT_DATETIME);

__PACKAGE__->meta(
    tables => {
        site => {
            fields => [
                {name => 'id',         type => 'BIGINT',  unsigned => 1,   not_null => 1, autoincrement => 1},
                {name => 'domain',     type => 'VARCHAR', length   => 255, not_null => 1},
                {name => 'multistate', type => 'BIGINT',  unsigned => 1,   not_null => 1, default       => 0},
                {name => 'create_date', type => 'DATETIME', not_null => 1,    default => $MYSQL_DEFAULT_DATETIME},
                {name => 'is_graysite', type => 'BOOLEAN',  not_null => TRUE, default => 0},
                {name => 'waiting_moderation', type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'done_moderation',    type => 'DATETIME', not_null => TRUE, default => $MYSQL_MIN_DATETIME},
                {name => 'opts',               type => 'JSON',     not_null => TRUE},
            ],
            primary_key => ['id'],
            indexes     => [{fields => ['domain'], unique => 1}, {fields => ['multistate'], type => 'HASH'}]
        },

        owner_site => {
            fields => [
                {name => 'domain_id'},
                {name => 'user_id'},
                {name => 'create_date', type => 'DATETIME', not_null => 1, default => $MYSQL_MIN_DATETIME,},
            ],
            primary_key  => [qw(domain_id user_id)],
            foreign_keys => [[['domain_id'] => site => ['id']], [['user_id'] => users => ['id']]]
        },

        site_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'site',
            elem_table_pk => ['id'],
            with_opts     => TRUE,
        },

        focus_domains_for_managers_mailing_lists => {
            fields => [
                {name => 'domain', type => 'VARCHAR', length   => 255, not_null => 1,},
                {name => 'tier',   type => 'BIGINT',  unsigned => 1,   not_null => 1,},
            ],
            primary_key => [qw(domain)],
        },
    }
);

TRUE;
