package Application::Model::PartnerDB::StatDownloadData;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        stat_download_data => {
            fields => [
                {name => 'id',        type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'method',    type => 'VARCHAR', length   => 255,  not_null => 1},
                {name => 'stat_date', type => 'DATE',    not_null => 1},
                {name => 'hostname',    type => 'VARCHAR',  length   => 255,  not_null => 1},
                {name => 'checksum',    type => 'INT',      unsigned => 1,    not_null => 1},
                {name => 'update_time', type => 'DATETIME', not_null => 1},
                {name => 'filename',    type => 'VARCHAR',  length   => 1024},
                {name => 'sync',        type => 'BOOLEAN',  not_null => TRUE, default  => 1},
            ],
            primary_key => [qw(id)],
            indexes     => [{fields => ['method', 'stat_date', 'update_time', 'hostname'], unique => TRUE}],
        },
    }
);

TRUE;
