package Application::Model::PartnerDB::Statistics;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

# Таблицы со статистикой должны быть в файлах продуктов, здесь только общие

__PACKAGE__->meta(
    tables => {
        currencies => {
            fields => [
                {name => 'id',      type => 'TINYINT', unsigned => 1, not_null => 1},
                {name => 'code',    type => 'VARCHAR', length   => 3, not_null => 1},
                {name => 'country', type => 'VARCHAR', length   => 3, not_null => 1},
                {name => 'symbol',  type => 'VARCHAR', length   => 2, not_null => 1},
            ],
            primary_key => ['id'],
            indexes     => [{fields => ['code'], unique => 1}],
        },
        stat_report_params_digest => {
            fields => [
                {name => 'id',          type => 'VARCHAR',  length   => 255, not_null => TRUE},
                {name => 'params',      type => 'TEXT',     not_null => TRUE},
                {name => 'update_date', type => 'DATETIME', not_null => TRUE},
            ],
            primary_key => [qw(id)],
        },
    }
);
