package Application::Model::PartnerDB::StatisticsReports;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        statistics_reports => {
            fields => [
                {name => 'id',        type => 'VARCHAR', length => 64, not_null => TRUE},
                {name => 'report_id', type => 'VARCHAR', length => 64,},
                {name => 'caption',     type => 'VARCHAR', length => 255, not_null => TRUE, i18n => TRUE},
                {name => 'description', type => 'VARCHAR', length => 255,},
                {name => 'level',},
                {name => 'query',      type => 'TEXT',    not_null => TRUE,},
                {name => 'owner_id',   type => 'BIGINT',  unsigned => TRUE,},
                {name => 'not_show',   type => 'BOOLEAN', not_null => TRUE, default => 0},
                {name => 'multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE, default => 0},
                {
                    name     => 'report_type',
                    type     => 'ENUM',
                    values   => [qw(pi mol)],
                    not_null => TRUE,
                    default  => 'pi',
                },
                {name => 'category_bits', type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
                {name => 'report_order',  type => 'INT', unsigned => TRUE, not_null => TRUE, default => 0},
            ],
            primary_key  => ['id'],
            foreign_keys => [[['level'] => statistics_reports_level_order => ['level_id']],],
        },

        statistics_reports_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'statistics_reports',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },

        statistics_reports_level_order => {
            fields => [
                {name => 'level_id', type => 'VARCHAR',  length   => 64,   not_null => TRUE},
                {name => 'order',    type => 'SMALLINT', unsigned => TRUE, not_null => TRUE},
            ],
            primary_key => ['level_id'],
        },

        deleted_standart_statistics_reports => {
            fields => [{name => 'user_id',}, {name => 'report_id',},],
            foreign_keys => [[['user_id'] => users => ['id']], [['report_id'] => statistics_reports => ['id']]],
            indexes => [{fields => [qw(user_id report_id)], unique => TRUE}],
        },
    }
);

TRUE;
