package Application::Model::PartnerDB::TNSDicts;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

my $tns_dict_brand = {
    fields => [
        {name => 'bid',  type => 'INT',     not_null => TRUE},
        {name => 'name', type => 'VARCHAR', length   => 50, not_null => TRUE, i18n => TRUE},
        {name => 'note',    type => 'VARCHAR', length   => 250, not_null => TRUE},
        {name => 'status',  type => 'CHAR',    length   => 1,   not_null => TRUE},
        {name => 'file_id', type => 'INT',     not_null => TRUE},
        {name => 'hidden',  type => 'BOOLEAN', not_null => TRUE},
    ],
    primary_key => ['bid']
};

my $tns_dict_article = {
    fields => [
        {name => 'sid',  type => 'INT',     not_null => TRUE},
        {name => 'grid', type => 'INT',     not_null => TRUE},
        {name => 'lev',  type => 'INT',     not_null => TRUE},
        {name => 'name', type => 'VARCHAR', length   => 50, not_null => TRUE, i18n => TRUE},
        {name => 'note', type => 'VARCHAR', length   => 250},
        {name => 'status',  type => 'CHAR',    length   => 1,    not_null => TRUE},
        {name => 'file_id', type => 'INT',     not_null => TRUE},
        {name => 'hidden',  type => 'BOOLEAN', not_null => TRUE, default  => 0},
    ],
    primary_key => ['sid']
};

__PACKAGE__->meta(
    tables => {
        tns_dict_brand     => $tns_dict_brand,
        tns_dict_brand_tmp => $tns_dict_brand,

        tns_dict_article     => $tns_dict_article,
        tns_dict_article_tmp => $tns_dict_article,
    }
);

TRUE;
