package Application::Model::PartnerDB::TextTemplate;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

__PACKAGE__->meta(
    tables => {
        text_template => {
            fields => [
                {name => 'id',         type => 'INT',        unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
                {name => 'caption',    type => 'VARCHAR',    length   => 255,  not_null => TRUE},
                {name => 'key',        type => 'VARCHAR',    length   => 255,  not_null => FALSE},
                {name => 'content',    type => 'MEDIUMTEXT', not_null => TRUE, i18n     => TRUE},
                {name => 'multistate', type => 'INT',        unsigned => TRUE, not_null => TRUE, default       => 0},
            ],
            primary_key => ['id'],
            indexes     => [{fields => ['key'], unique => TRUE}],
        },
        text_template_action_log => {
            type          => 'MultistateActionLog',
            elem_table    => 'text_template',
            elem_table_pk => ['id'],
            with_opts     => TRUE
        },
    }
);

TRUE;
